Review

# Investigating the Influence of Artificial Intelligence on Business Value in the Digital Era of Strategy: A Literature Review

Nikolaos-Alexandros Perifanis $\textcircled{1}$ and Fotis Kitsios $\ast \textcircled { \scriptsize { \parallel } }$

Citation: Perifanis, N.-A.; Kitsios, F. Investigating the Influence of Artificial Intelligence on Business Value in the Digital Era of Strategy: A Literature Review. Information 2023, 14, 85. https://doi.org/10.3390/ info14020085

Academic Editor: Dimitris Apostolou

Received: 1 December 2022   
Revised: 19 January 2023   
Accepted: 30 January 2023   
Published: 2 February 2023

Copyright: $^ ©$ 2023 by the authors. Licensee MDPI, Basel, Switzerland. This article is an open access article distributed under the terms and conditions of the Creative Commons Attribution (CC BY) license (https:// creativecommons.org/licenses/by/ 4.0/).

Department of Applied Informatics, University of Macedonia, GR54636 Thessaloniki, Greece \* Correspondence: kitsios@uom.gr

Abstract: For organizations, the development of new business models and competitive advantages through the integration of artificial intelligence (AI) in business and IT strategies holds considerable promise. The majority of businesses are finding it difficult to take advantage of the opportunities for value creation while other pioneers are successfully utilizing AI. On the basis of the research methodology of Webster and Watson (2020), 139 peer-reviewed articles were discussed. According to the literature, the performance advantages, success criteria, and difficulties of adopting AI have been emphasized in prior research. The results of this review revealed the open issues and topics that call for further research/examination in order to develop AI capabilities and integrate them into business/IT strategies in order to enhance various business value streams. Organizations will only succeed in the digital transformation alignment of the present era by precisely adopting and implementing these new, cutting-edge technologies. Despite the revolutionary potential advantages that AI capabilities may promote, the resource orchestration, along with governance in this dynamic environment, is still complex enough and in the early stages of research regarding the strategic implementation of AI in organizations, which is the issue this review aims to address and, as a result, assist present and future organizations effectively enhance various business value outcomes.

Keywords: artificial intelligence (AI); AI capability; business strategy; IT strategy; business value; digital transformation

# 1. Introduction

It has become apparent that both socio-technical and political-economic changes, along with demographic changes, have swiftly accelerated during the COVID-19 pandemic. Modern businesses have had to hone their adaptive capabilities to manage changing market dynamics and client behavior under these challenging circumstances. Rapid organization evolution is made possible by adaptive capabilities, which also act as a basis for organizational change and digital transformation [1,2], but still lack strategic guidelines in order to keep up with the exponential pace of modern technology [3]. Existing businesses use cutting-edge technologies to improve and adapt their operations. Artificial intelligence, also known as the next wave of analytics, is one of those technologies [4,5].

The phrase “artificial intelligence” refers to a wide range of leading-edge analytics, applications, and logic-based methods that imitate human behavior, decision-making, and processes including learning and problem-solving [6,7]. However, as part of the digital transformation, AI technologies give businesses several chances to transform their operations across numerous sectors [8]. Examples include applying AI-driven decisionmaking to loan, credit, or sales forecasts [9,10]. Additionally, AI can provide significant benefits by automating formerly manual procedures [11] and enabling enhanced processes where humans and AI collaborate in a positive way [12].

Senior executives view analytics and AI as crucial game changers enabling businesses to survive the present crisis, according to a recent Gartner report [13]. Despite the excitement surrounding AI’s promise, presently, there is a substantial scholarly discussion about the adoption obstacles and the skills and abilities required for useful AI results from a strategic point of view [14,15]. AI can benefit businesses significantly, but in order to implement AI and enable a high effect that does not undo all the expenditure and effort, organizations must define a compelling common vision when a substantial shift is necessary [16–18]. Additionally, businesses must use several distinctive technologies such as AI to build adaptive transformation and sense-and-respond capabilities that will spur innovation, enhance customer service and experience, and promote improved performance [5,19–23].

Information systems (IS) and business research from academic and professional institutions indicate that artificial intelligence is gaining traction in the market [24–28]. Since the 1950s, when the idea of artificial intelligence first surfaced, research on the subject has been advancing steadily. However, over the past 10 to 15 years, there has been a significant acceleration in the development and practical use of AI due to the growing availability of huge data, improved computational processing power, and novel AI approaches, learning algorithms, and applications [29].

AI has a growing impact on a variety of societal spheres, including marketing, healthcare, and human rights. It could be detrimental to let the creation of AI applications progress without any oversight [30,31]. As a result, it is critical to support a reliable AI that complies with legal requirements and upholds moral standards (from a technical and social perspective). Because AI should be viewed as a dynamic computational frontier, governance should therefore go beyond just the content and also encompass its analysis [25]. To address issues such as the lack of alignment between business users and analytics practitioners, governance mechanisms for analytics are also required in addition to IT and data governance [32].

Although other scholars are also of the same mind, many organizations are still experimenting with AI (e.g., using first pilots), and only a few organizations embed AI as part of the everyday working routines across the organization [24,33]. Nevertheless, organizations have invested heavily in AI and underlying machine learning algorithms to enhance business operations and support decision-making [34]. As mentioned previously, technology such as AI not only presents new opportunities and advantages for businesses but also new difficulties [31,35]. AI solutions are being implemented and used by businesses in an effort to automate processes, boost productivity, cut costs, and gain a competitive edge over rivals [36–38]. A crucial element in accomplishing these objectives is AI governance. AI governance “may be characterized as a collection of tools, methods, and levers that influence AI development and applications,” claim Butcher and Beridze [39]. However, there is still an opportunity for research on how to implement AI governance within a company and how AI governance helps a company achieve its objectives.

We are aware, thanks to the IS literature, that organizations develop distinctive, difficult-to-copy capabilities by integrating and using a variety of complementary firm-level resources [14,40,41]. Building on this body of research, this study views AI technology as one such resource that, while necessary for the development of an AI capability, is not sufficient in and of itself [14]. This essentially indicates that while AI approaches are readily available on the market and susceptible to replication, they are unlikely to generate significant competitive advantages on their own. Additionally, the data needed to power these methods by itself will not be enough to develop distinct AI capabilities [13]. Early reports from industry leaders in AI adoption show that organizations need a special mix of physical, human, and organizational resources to establish an AI capability that can really add value by distinguishing it from competitors [14,42]. There is little comprehensive theoretical and empirically proven knowledge regarding how to profoundly develop and use AI capabilities [43,44].

According to van de Wetering et al. [13], adaptive transformation capability is defined as a firm’s ability to recognize and seize new market and technological opportunities and develop organizational capabilities concomitantly with the adoption of new strategic directions [3,42,45]. This acumen can also be thought of as the dynamic ability to deploy organizational resources and competencies to accomplish the intended outcome [46] and drive the organization’s future entrepreneurial activities and business value potential [47]. However, little is now known about the ambidextrous use of AI, how enterprises can utilize it habitually and creatively, how this supports dynamic capabilities, and particularly how they work together to generate value [48]. While more firms are using AI today to improve and adapt organizational operations, there is a lack of theoretically grounded or empirically validated data to help organizations with their strategic orientation [42,45]. As a result, this paper’s main goal is to draw attention to key aspects of how artificial intelligence capabilities contribute to different perspectives on the business value realized through the alignment of business and IT strategies during the digital transformation in order to address this research problem in the aforementioned connection. In total, 139 sources were examined after being analyzed through the lens of the Webster and Watson methodology [49]. Companies all around the world are struggling to incorporate AI since it is continually changing and requires particular consideration of all of its different value dimensions. It is crucial to keep track of the most recent findings on the improved business value outcomes produced by the deployment of AI in the various modes of digital transformation as AI progresses from ordinary algorithms to revolutionary super intelligence and beyond.

This study is about the integration of AI with business and IT strategies in the context of digital transformation. The research found that organizations commonly undergo a digital transition driven by technological developments and regulatory changes and that the integration of AI capabilities with business and IT strategies is crucial for achieving improved business value outcomes and enabling digital transformation alignment. The study also highlighted the importance of a dual strategic focus on innovative and routine AI deployment, as well as the need for responsible AI governance and the use of AI to support adaptive transformation. The study’s findings contribute to our understanding of how organizations can optimize their use of AI to promote strategic flexibility and benefit realization.

The structure of the current work is as follows: The methodology used to conduct the literature review is described in Section 2. The results that emerged through the assessment of the articles are discussed in Section 3. The last section concludes by encouraging the scientific community to further investigate the problems and connections identified in this conceptual model by summarizing the research’s findings, stating its implications, and outlining its limitations.

# 2. Methodology and Data

Our research was conducted following the guidelines of Webster and Watson’s [49] systematic literature review. This is a procedure that consists of three phases: (1) In order to identify databases and keywords, a survey of the most recent literature was conducted. (2) Following this, a thorough backward search was performed to look into citations, and a forward search was performed to look for citations of the selected publications. (3) At the conclusion of the procedure, potential study opportunities were identified, and all of the articles were categorized by concept in accordance with their individual contents.

# 2.1. Prior Literature Reviews

Since the number of studies on AI has been growing dramatically over the years, it is not surprising that systematic literature reviews [1,7,26,27,50–54] and bibliometric analysis [55–57] are widely used as review methods in the management sector. Remarkably, the studies cover a broad range of topics, indicating that AI, in the organizational setting, is being applied in different areas for different purposes. To the best of our knowledge, no recent literature review has specifically discussed the integration of AI capabilities with Business/IT strategies in order to promote enhanced business value outcomes. Rather, these reviews have investigated the phenomenon by investigating a wide range of factors that can affect this relationship. All of these reviews are presented below (Table 1).

Table 1. Prior Literature Reviews. Source: Own elaboration.   

<html><body><table><tr><td>Authors</td><td>Year</td><td>Methodology</td><td>Findings</td></tr><tr><td>Kitsios and Kamariotou [1]</td><td>2021</td><td></td><td>Aalythe pi</td></tr><tr><td>Cebeci [50]</td><td>2021</td><td></td><td></td></tr><tr><td>Enholm et al. [51]</td><td>2021</td><td></td><td></td></tr><tr><td>Keding [27]</td><td>2019</td><td></td><td>Review of articles on the use of AI techniques in strategic management, and predictive logic in business models.</td></tr><tr><td> Zuiderwijk et al [52]</td><td>2021</td><td></td><td></td></tr><tr><td>Borges et al. [26]</td><td>2021</td><td>Systematic Literature Review 2 databases 41 articles published between 2009-2020</td><td>A review of the integration of AI toorganizational strategy. The results were analyzed basedon four standpoints: Automation,decision-making, customer engagement and new products,services ofering.</td></tr><tr><td> Trunk et al. [7]</td><td>2020</td><td></td><td>definehowpeeAisisieekaa</td></tr><tr><td>Grover et al [53]</td><td>2022</td><td> Systematic Literature Review</td><td>AreviewofAiratinia</td></tr><tr><td>Caner and Bhatti [54]</td><td>2020</td><td>between 2015-2019</td><td></td></tr><tr><td> Smacchia and Za [55]</td><td>2022</td><td>CompuatinalLiteatueReview</td><td></td></tr><tr><td>Di Viao et al. [56]</td><td>2020</td><td></td><td>Wt</td></tr><tr><td>Dhamija and Bag [57]</td><td>2020</td><td>BibliometricLitspaureReyiewetworkanalysis)</td><td>ee</td></tr></table></body></html>

To begin with, Kitsios and Kamariotou [1] offered a study agenda on the use of AI and ML in organizational planning and decision-making procedures. Future research needs were identified, and a theoretical model was created to discuss the four sources of value creation, including AI and machine learning in organizations; the alignment of AI tools and information technology (IT) with organizational strategy; AI, knowledge management, and the decision-making process; and AI, service innovation, and value. By completing context, journal, and concept-based analyses using preferences for the AI technique, areas of application, and sector preferences perspectives, the study of Çebeci [50] analyzed the current status and orientation of AI studies in the MIS literature and presented it in detail.

The paper by Enholm et al. [51] offers a systematic literature review that makes an effort to clarify how organizations can use AI technologies in their operations and elucidate the value-generating mechanisms. It synthesizes the existing literature and highlights (1) the major enablers and inhibitors of AI adoption and use; (2) the typologies of AI use in the organizational setting; and (3) the first- and second-order effects of AI. The report also presents the gaps in the literature and creates a research agenda that suggests areas that should be studied in more detail in the future. The framework developed by Keding [27] illustrates the structure of the research field by grouping pertinent articles into two research scopes: Condition-oriented research, which investigates antecedents for leveraging the use of AI in strategic management, and outcome-oriented research, which examines the effects of AI in strategic management at both the individual and organizational levels. In order to create a research agenda, Zuiderwijk et al. [52] conducted a thorough evaluation of the body of literature on the implications of using AI in public governance. They classified the possible advantages of AI application in government into nine categories using their qualitative analysis: (1) Benefits for efficiency and performance, (2) benefits for risk identification and monitoring, (3) economic benefits, (4) benefits for data and information processing, (5) benefits for services, (6) benefits for society as a whole, (7) benefits for decision-making, (8) benefits for engagement and interaction, and (9) benefits for sustainability. The following eight categories were used to identify issues associated with the application of AI in government: (1) Data challenges, (2) organizational and managerial challenges, (3) skills challenges, (4) interpretation challenges, (5) ethical and legitimacy challenges, (6) political, legal, and policy challenges, (7) social and societal challenges, and (8) economic challenges. A literature review was conducted by Borges et al. [26] to examine the relationship between AI and corporate strategy.

According to this perspective, this article aimed to fill this gap by conducting a thorough literature review focused on the integration of AI with business strategy, combining the existing approaches with models, highlighting the anticipated advantages, difficulties, and opportunities, and launching a discussion about potential new research directions. Trunk et al. [7] conducted a literature study to examine how AI and corporate decisionmaking interact in dynamic situations. In order to provide a summary of the prospects of existing studies in linking AI with business decision-making in dynamic environments, the authors searched for peer-reviewed publications and performed a content analysis. Insight was provided in a theoretical framework that first outlines how humans might use AI for decision-making in dynamic situations before outlining the challenges, prerequisites, and implications that need to be taken into account. Grover and colleagues [53] investigated the viability of using AI within an organization based on six factors, including job fit, complexity, long-term effects, affect towards use, social factors, and facilitating conditions for various elements of operations management, by mining the collective knowledge of experts on Twitter and through the academic literature. A systematic review of the literature in peer-reviewed scientific journal articles was conducted by Caner and Bhatti [54] in order to present a theoretical model for examining the AI organizational strategy. They deduced that the key elements of AI in organizations are its capabilities and limitations, financial matters and AI, organizational functions and AI, workforce, industries and AI, and laws and ethics of AI in identifying AI corporate strategy.

To investigate the AI controversy within organizational and managerial studies, Smacchia and Za [55] undertook a computational literature survey in their work. They also identified which publications and research fields this argument has evolved in over time via impact and content analyses. Di Vaio et al. [56] explored the body of literature on the application of artificial intelligence to the development of sustainable business models, offered a quantitative overview of the body of research in the area, and discussed the connections between AI, the exponential growth of machine learning, and sustainable development. Lastly, according to Dhamija and Bag’s [57] cluster analysis results on the key topics for current and future researchers in the field of artificial intelligence, six clusters emerged: (1) Artificial intelligence and optimization, (2) engineering/research and automation, (3) operational performance and machine learning, (4) sustainable supply chains and sustainable development, (5) technology adoption and green supply chain management, and (6) internet.

# 2.2. Article Selection

The papers were found in the Scopus, Science Direct, and Web of Science databases using a combination of the phrases Artificial Intelligence (AI), AI capability, business strategy, IT strategy, business value, and digital transformation in the title, keyword, and abstract sections of the search query. Each article was published in a journal that had undergone peer review or in conference proceedings. There were no limits with regard to the year of publishing.

The search for the aforementioned keywords resulted in the collection of a total of 1738 articles. Following the application of language, source, and category restrictions, there were a total of 942 articles remaining. After reviewing the contents of the remaining articles, we decided not to include 547 articles because of their titles, 164 articles because of their abstracts, and 109 articles because of their actual content. After that, 6 duplicate articles were eliminated, bringing the total number of articles down to 116. In addition to these, 12 articles were added as a result of the forward search, and 11 articles were added as a result of the backward search. This resulted in 139 articles being available for examination (Figure 1).

The search was finished when repeating articles for different keyword combinations were found. The necessary number of articles had been acquired to match prior studies. The major findings and contributions for each paper, along with the illustrative components, were compiled on an Excel data extraction sheet, which was then used to evaluate the final sample.

The novelty of this research lies in its focus on the integration of AI with business and IT strategies as a key enabler of digital transformation alignment, which improves a variety of organizational business value outcomes. The study conducted a systematic literature review using a particular technique that has been widely utilized in the past to investigate information systems strategy and subjects related to digital transformation. This research also examined the specific difficulties, solutions, levers, and streams in the context of responsible AI governance and the use of its ambidexterity in the development of AI capabilities.

The research was developed with a scientific focus to present a more detailed picture of how AI affects organizations and demonstrate the critical role AI capabilities play in enabling the integration of digital transformation alignment, ultimately generating a competitive advantage. The study also revealed the enablers and drivers for pursuing AI’s increased business value and emphasizes the need for organizations to have a dual strategic focus on innovative and routine AI deployment for its synergistic impact on the strategic flexibility of the organization.

Additionally, this research contributes to our understanding of the ways organizations must optimize their AI resources to promote strategic flexibility and benefit realization at the strategic level of the organization and contributes to the current body of knowledge on shaping and developing dynamic capabilities. Furthermore, the research suggests that by establishing digital skills that are challenging to compete with, businesses can traverse challenging and shifting business environments. Additionally, the research refutes theerature review using a particular technique that has been widely utilized in the past to notion that AI is frequently monolithic and unable to adjust to changing surroundings andinvestigate information systems strategy and subjects related to digital transformation. highlights the importance of using AI to support an adaptive transformation instead ofThis research also examined the specific difficulties, solutions, levers, and streams in the impeding it. Finally, the research draws attention to the importance of good AI governancecontext of responsible AI governance and the use of its ambidexterity in the development and its direct impact on an organization’s results.of AI capabilities.

![](images/773d20c4e2685aff543be2bcf128abc286ce07056b146c70ba3bbd3185ab9537.jpg)  
Figure 1. Article selection process Source: Own elaboration.Figure 1. Article selection process Source: Own elaboration.

# 2.3. Classification Framework

ow AI affects organizations and demonstrate the critical role AI capabilities play in A classification framework was applied to the investigation of one hundred and sixtyenabling the integration of digital transformation alignment, ultimately generating a com-nine articles. All of the articles were organized into two overarching concepts as follows: petitive advantage. The study also revealed the enablers and drivers for pursuing AI’s1. Artificial intelligence capabilities and 2. the integration of AI and business/IT strategy increased business value and emphasizes the need for organizations to have a dual stra-for enhanced business value. By providing additional knowledge in this domain and tegic focus on innovative and routine AI deployment for its synergistic impact on the stra-providing a better understanding of the strategic function of AI, these notions will aid tegic flexibility of the organization. present and future academics and researchers in growing the related research body. These papers are presented in Table A5 (Appendix A).

# 3. Results

# 3.1. Artificial Intelligence Capabilities in Organizations 3.1.1. AI Ambidexterity

Thinking, understanding, interpretation, learning, judging, and inference are some of the numerous skills that make up intelligence. People are able to perform tasks such as learning from experience, creating answers to various and unknowable challenges they confront, and reacting as quickly as possible to a new scenario because of their intelligence [50]. The heart of AI methodologies consists of these actions. Artificial intelligence refers to a broad range of methodologies that can generate solutions with comparable designs to solve issues and attempt to replicate the intelligence of people or other living things in the computer environment. The success of these methods in solving problems that are NP (nondeterministic polynomial)-Hard, or extremely difficult to solve with conventional methods, is their greatest advantage in business and personal life.

Significant scientific progress has been made in the field of AI over the past ten years, which is defined as “a system’s ability to properly interpret external data, to learn from that data and to use this knowledge learned to accomplish specific objectives and tasks through flexible adaptation” [58]. Algorithms are already becoming able to digitally perform operations that effectively and productively imitate human learning, profound judgment, and decision-making across a wide range of application domains, driven by a rise in data generation and computation power [9,59]. Examples of such business applications include product design, the gathering of limited external knowledge, talent recruitment and screening, and internal business operation optimization [60,61]. The taxonomy of artificial intelligence techniques, however, is not generally agreed upon. The majority of AI techniques are grouped under the headings Fuzzy Logic (FL), Artificial Neural Networks (ANN), Expert Systems (ES), and AI-supported Meta-heuristics (MH) approaches in Figure 2, which also presents the different types and applications of AI [27,50].

As a result of these advancements, management academics are becoming increasingly intrigued by AI’s potential to assist or change firms [62]. However, while the use of AI algorithms is currently the subject of extensive research in a variety of functional areas, such as human resource management, marketing, information systems, economics [63], finance, operations management, and manufacturing, much less focus has been placed on comprehending how the advent of AI alters the nature of strategizing—that is, the activities of those involved in the strategy process [64–66].

According to the ambidexterity theory, an organization’s strategic flexibility will result from placing an equal strategic focus on routine and innovative uses of AI [17,19,67]. The phrase “routine usage of AI” describes how an organization uses AI on a regular basis. As a result, this is seen as an exploitation and standardization posture that aims to enhance, expand, and promote incremental innovation in AI across a range of products and services a firm provides [19,20]. The routinized use of AI often entails standardizing working practices and operations using resources already at the disposal of the business (such as AI tools, frameworks, algorithms, and approaches) [68]. On the other hand, creative, emergent, and inventive use of AI in workers’ job processes is referred to as innovative application [69,70]. This perspective on AI application therefore stresses finding novel and creative methods to integrate AI into work processes [69], by offering wholly new or significantly improved client services. Additionally, the innovative application of AI is a catalyst for investigating and identifying new fields in which AI tools, applications, and uses can be implemented in business procedures [71]. This is accomplished, for instance, by starting a number of pilot programs and cutting-edge initiatives with AI at their core, learning from the outcomes, and then pushing the boundaries of organizational transformation [72].

AI ambidexterity, or the simultaneous adaptation of these two AI modes, enables businesses to sense their environment by examining real-time and large volumes of data, identifying and collecting customer needs and trends, discovering patterns, and extracting valuable data for decision-making processes [9,61,73]. According to [13], the ambidextrous use of AI in businesses will shape the organization’s dynamic capabilities as AI is used to address business problems, find innovative solutions, contribute to the success of business operations integration, and speed up change within the business [23,74]. Additionally, ambidexterity has been conceived in terms of temporal separation, which proposes that organizations should switch between periods of time that promote routine and standardization and times that prioritize creativity and exploration [75]. Last but not least, structurallyW divided ambidexterity relates to a dual organizational structure with entities (together with related systems, talents, and cultures) focusing on exploration and exploitation [21].

![](images/a217b90f3e9171b3874595fa2d8c4ade421d3b547f7171754ad0e79aad3777d6.jpg)  
ure 2. AI branches of types, applications, and techniques. Source: Own elaboFigure 2. AI branches of types, applications, and techniques. Source: Own elaboration.

It is not an easy procedure to capture the value from both opposing modes of operaAccording to the ambidexterity theory, an organization’s strategic flexibility tion, i.e., routine vs. innovative application of AI, as they require different organizational t from placing an equal strategic focus on routine and innovative uses of AI [17routines, capabilities, and routines. Instead, it is suggested in the literature that big data and phrase “routine usage of AI” describes how an organization uses AI on a regAI should be used as crucial organizational resources to enhance organizations’ dynamic As a result, this is seen as an exploitation and standardization posture that capacities and enable them to utilize their full strategic potential [13,76]. Additionally, it is important to involve stakeholders to ensure their full engagement, and all employees must be committed to the new improvement projects and the organization-wide alignment with the strategic direction [77]. In order to achieve outstanding and long-lasting economic benefits and strong adaptive capacities, organizations must align “innovation” with “routine” at the same time [31,63,78].

# 3.1.2. AI Capability Conceptualization

The effects of AI on managers and businesses have just recently become particularly interesting research-wise [66,79,80]. Some initial studies have been conducted on AI-driven business models [81], AI-related organizational decision-making [9,60,61], and how businesses may promote AI trust [82]. The practice-oriented management literature frequently outlines procedures and actions supervisors can take to implement AI in their organizations [6,10,42]. There is broad agreement that the effects of AI encompass fundamentally new modes of corporate operation and expansion in addition to incremental process improvements. However, there is a shortage of research on how AI can be used to gain new skills and switch to business models that are powered by AI [10].

Indeed, surveys have found that the biggest obstacle to the application of AI is a lack of AI capabilities [6]. Although most academics concur that AI capabilities are relevant, the respective literature does not give a clear definition of what AI capabilities are. For instance, several capabilities that are pertinent to the goal of integrating AI into a firm are mentioned in the managerial guidelines of Brock and Von Wangenheim [6]. These academics, however, take a rather broad stance, claiming that, in addition to data science and technological talents, the integration of AI calls for strategic competences. As a result, these publications’ depth of insight is restricted, especially considering that illustrating these skills was not their only, or even primary, goal. Researchers and practitioners are still unclear about the capabilities and underlying processes that are necessary in order for businesses to be able to fully utilize AI [33,83,84]. Profiting from a digital capability such as artificial intelligence “is not so much a technology challenge as it is a challenge to harness knowledge to create the organizational knowing to continually optimize the value that can be derived from digital technologies” [59].

As AI is a novel technology, a greater number of research studies are being undertaken to determine the value that AI or its capabilities can bring to businesses. The main factors that influence the adoption of machine learning and top management support are uncovered by Reis et al. in [85]. Based on the mini-case studies of service provider websites, Wamba-Taguimdje et al. [16] investigated the connection between AI resources and business value. Alsheibani et al. [86] examined the issues surrounding the production of AI economic value by thoroughly reviewing real-world AI use cases and the body of prior research. They identified six AI-related organizational obstacles, including the business case for AI, the relative advantages of AI, top management support, efficient data utilization, AI talent, and AI compatibility. For the purpose of identifying the mechanisms generating AI business value, Enholm et al. [51] summarized the existing literature and provided a narrative review. They identified a number of AI use cases, facilitators, and barriers, as well as the effects of AI, particularly on competitive performance. As shown in prior studies, the introduction of AI technologies in itself is insufficient to increase organizational performance in a constantly evolving digital society, but their complementary interaction with knowledge exchange does.

Additionally, the idea of an AI capacity has been put forward in earlier research to broaden the perspective on AI from just focusing on technical resources to also include all relevant organizational resources that are crucial for realizing the full strategic potential of AI [42,45,50]. According to research on AI capabilities, businesses need to have a few key resources in order to develop a capability that would allow them to adopt AI and reap performance advantages [14,16,74]. Organizations can incorporate AI-specific resources, such as AI algorithms, training data, etc., thanks to AI capabilities, which enable value generation. Sjödin et al. [87] analyzed case studies to examine how manufacturing companies create AI capabilities and discovered three key sets of capabilities: The data pipeline, algorithm development, and AI democratization. Through a thorough survey study, Mikalef and Gupta [14] came to the conclusion that by nurturing AI capabilities connected to human talents, tangible resources, and intangible resources, businesses could improve organizational innovation and performance. The survey’s list of AI resources driving AI capabilities was structured to investigate any extra or other significant aspects. Through exploratory interviews with professionals from business, consulting, and academia, Weber et al. [88] identified four organizational skills for AI implementation: AI project planning, the co-development of AI systems, data management, and AI model lifecycle management.

There is a paucity of knowledge regarding how AI resources or AI capabilities enable organizational business value, despite the existing literature discussing the construct of AI capability and the correlation between AI and business value [70]. As a result, in order to clarify the role of AI resources—the combination of AI assets and AI capabilities—in the development of business value and delve deeper into the topic of AI capabilities, an exploratory research study that adopts an interpretative approach is required. Despite the large potential that AI technologies hold, Brynjolfsson et al. [6] highlight that we are dealing with a modern productivity paradox. According to the authors, one of the main reasons AI has yet to deliver expected outcomes is due to implementation and restructuring lags. Organizations, therefore, need to invest in complementary resources to be able to leverage their AI investments. Understanding what complementary resources need to be developed and implementing them is imperative in the quest of realizing performance gains from AI. In other words, it is time to examine how organizations build an AI capability.

As previously indicated, the study by Mikalef and Gupta [14] seeks to investigate the resources needed to develop an AI capability by drawing on the resource-based theory (RBT) of the organization. The RBT is a suitable theoretical lens for dynamic and turbulent contexts, especially where resource complementarity is encouraged, and organizations create unique competencies around their respective resources. According to Melville et al. [89], the RBT enables researchers to create empirically testable hypotheses, the evaluation of which will increase our knowledge of the importance of various IT resources and how they impact organizational performance [43,90]. The RBT, according to Wade and Hulland [91], offers a solid framework for assessing the strategic value of information system resources. The fact that the RBT is a widely recognized theory in other business disciplines, such as operations management and marketing supply chain management [92–94], among others, demonstrates the RBT’s value in describing organizational-level events. As a result, Mikalef and Gupta [14] used current studies on AI in the organizational environment and previous work on IT competence to build the idea of an AI capability.

The many sorts of resources needed for the growth of organizational capabilities that drive performance have been outlined in a number of studies [95]. One of the most popular classifications is that offered by Grant [14], who distinguishes between tangible (such as material and financial resources), human abilities (expertise and skills of employees), and intangible (knowledge and skills of customers) (e.g., synergy, coordination, and strategic orientation). The IS literature makes considerable use of this division of resources into materials, human skills, and intangible resources [24,96]. To effectively leverage their investments and produce economic value, firms must create a special set of resources, as is the case with any new technology, including AI.

The studies mentioned so far, as well as a number of other academic papers and business reports, illustrate the diversity of resources that businesses must develop in order to realize a return on their investments in AI. However, theoretically valid research on how businesses might develop AI capabilities is lacking [14]. This is a critical gap for both research and practice since it may point to the main areas that businesses should concentrate on when implementing AI projects and give them a basis for estimating the potential business value and different generation mechanisms. Building on the theoretical foundations of the RBT [93,94] and empirical work implementing the RBT in the IS domain [91,97], as well as on recent studies that highlight the challenges related to AI adoption and value generation [5,33,98], Figure 3 presents the classification and the key types of resources in every category.

![](images/8914d5478b4c5e2b86922018f7cf4777b11a13749746c60974b93c7f18c505de.jpg)  
Figure 3. Categorization of resources to ideation and implementation of AI capabilities Source: n of resources Own elaboration.

In more detail, data, technology, and basic resources are examples of tangible resources, which are defined as those that may be traded or purchased on the open market [93]. For instance, there are various categories of tangible resources, such as financial assets and efined as those that may be traded or purchased on the open market physical assets such as debt and equity. As tangible resources are largely accessible to all ere are various categories of tangible resources, such as financial as-businesses on the market, they are unlikely to offer a distinct competitive edge. However, while tangible resources are required, they are insufficient on their own to build capacities. Regarding the second group, an organization’s human capital is frequently evaluated by s on the market, they are unlikely to offer a distinct competitive edge. evaluating the knowledge, skills, experience, leadership traits, vision, communication and ible resources are required, they are insufficient on their own to build collaboration skills, and problem-solving prowess of its staff. Technical and business skills have been highlighted as crucial human resource pillars in previous studies on digital capabilities [93,97]. This study argues that technical and business capabilities specific to ting the knowledge, skills, experience, leadership traits, vision, com-AI are two crucial elements of a company’s human AI resources. In relation to the third aboration skills, and problem-solving prowess of its staff. Technical category, insecure and unstable marketplaces place a greater emphasis on intangible resources since those are harder for rival companies to reproduce [14]. Intangible resources are far more elusive and challenging to locate within organizations than the other two pabilities [93,97]. This study argues that technical and business capa-types of resources. Nevertheless, despite being challenging to quantify, they fall under the are two crucial elements of a company’s human AI resources. In re-category of resources that satisfy the RBT’s VRIN (Valuable, Rare, Imperfectly Imitable, Non-Substitutable) classification [99,100]. As a result of their extreme heterogeneity and singularity, resources cannot be compared across firms. Because they are created through a ces since those are harder for rival companies to reproduce [14]. In-special synthesis of organizational history, people, processes, and conditions that define re far more elusive and challenging to locate within organizations organizations, intangible resources are heterogeneous and non-replicable. A lengthy history of empirical IS research [89] and early publications on the factors that influence AI success [5,33] emphasize the significance of intangible resources in gaining business adategory of resources that satisfy the RBT’s VRIN (Valuable, Rare, Im-vantages from accepted technology. Interdepartmental cooperation, organizational change on-Substitutable) classification [99,100]. As a result of their extreme capability, and risk proclivity are some of the resources that have been identified for AI [14]. Since managers and practitioners can create specific benchmark criteria and gauge their readiness in each of the dimensions, the RBT and the identification of key resources in the building of a capability are also significant perspectives for practice [101]. They can then identify possible flaws that can be resolved with focused efforts.

# 3.1.3. AI Resources Orchestration

Resource orchestration is a comprehensive method for organizing a company’s resources, grouping the current resources to produce new capabilities, and utilizing them with the aim of enhancing both business and customer value [102]. Structuring, aggregating, and leveraging are the three primary components, and as presented previously in Figure 3, each component includes three subprocesses. Since the environment causes uncertainty, which could lead to instability for an organization and undermine its competitive edge over competitors, it has an impact on the linkages between resources that must be addressed seriously [103].

The way a company structures its resource portfolio affects the tangible and intangible resources it has, which determines the potential value it may create at any specific time. Data, technology infrastructure, and people skills and expertise, as well as other intangible resources such as a culture of learning and initiative, are examples of such resources as aforementioned [81]. This procedure is crucial because it gives businesses the resources they need to develop new capabilities. This means that, in the context of AI, the types of AI-based capabilities that a company can develop (such as developing NLP tools, intelligent assistants, and forecasting) strongly depend on the data, infrastructure, competences, and other relevant resources that are widely obtainable [14].

Acquiring in the context of artificial intelligence might mean either employing staff with in-depth expertise in AI systems or purchasing the necessary technological infrastructure, such as clusters with extremely high computation power [103]. This activity is essential for businesses that need to continuously develop and enhance their AI skills, especially if they are unable to outsource operations. Although expensive, an acquisition decision could strain the company’s budgetary management in an environment of high uncertainty [104]. Managers must use the new resources wisely by developing a new range of responses based on market prospects [105]. For instance, investing in an expensive dataset to supplement already-existing data sources could prove to be a dangerous move because the results might not be as anticipated.

The creation of internal resources is what accumulation is all about. When businesses lack the necessary resources and are unable to adapt to changing market conditions, accumulation becomes important [105]. If not, it will be very challenging to fill the gap in time and produce gains when new opportunities arise or the environment is uncertain, such as when high-value employees leave the company [102]. As an example, the knowledge of developing AI systems or managing AI projects should be accumulated in an adequate number of employees increasing their tacit knowledge. As a result, business expertise, development information, and general know-how that exiting personnel had are not included in the company’s tacit knowledge, which could lead to gaps in producing the knowledge required for future development [43]. Compared to acquiring them from the factor market, being able to collect all pertinent data internally should be given priority in such efforts.

Releasing firm-controlled resources is referred to as divesting. Resources are few in businesses, therefore it is critical to free them up for other work. In order to develop AI capabilities, it is crucial to divest outdated systems and infrastructure, such as code written in less-preferred machine learning languages such as Python or R or computer clusters with insufficient processing capability [10]. Additionally, keeping vast amounts of low-value data, typically data used for forecasting or constructing models, simply complicates things for technical staff and uses up storage space [13,76]. It is crucial to meticulously account for each resource that is divested though, as it can be challenging to re-purchase or accumulate those resources in highly unpredictable circumstances. This applies to personnel with specific knowledge and skills and data and technology resources.

Combining resources to produce capabilities is the process of bundling resources. The mere possession of a resource does not confer an advantage. This refers to knowing the areas of application on which AI initiatives can be focused in the context of its utilization. Three subprocesses make up the bundling process: Stabilizing, enriching, and pioneering.

Tiny enhancements to current capabilities are provided through stabilizing. However, it helps to create value by enabling the company to hold onto its competitive edge over time. In the case of AI deployment, this could entail teaching machine learning to software developers or instructing analysts on how to make use of an interactive interface with the AI [15]. However, stabilizing may not be a good option in highly unpredictable environments because drastic and urgent adjustments may be required [104].

Enriching is about spreading an existing capability. This can be achieved through expanding resources, developing new skills, or forming new partnerships with businesses that have access to the necessary resources. Companies that use AI applications need data that other businesses have access to or even people with extensive understanding of tackling AI-specific problems in order to develop their AI models [7]. Alliances can offer essential skills for attaining competitive advantage without incurring significant risks, which is advantageous for both parties [106]. However, other businesses might use the same tactics, thus the competitive advantage might only be momentary and fleeting.

Pioneering is the process of integrating brand-new materials that have been obtained from the market and engaging in exploratory learning. This could entail the bisociation process, which involves combining information that is dissimilar and unrelated [4]. This may imply using data sources that are vastly different from those owned or controlled by the company when it comes to AI applications, or it could entail hiring employees with distinctive and completely different skill sets [10]. Being able to offer value propositions that outperform rivals in ambiguous environments contributes to a competitive advantage. In order to create such value propositions, pioneering is an essential process.

Leveraging entails mobilizing, coordinating, and deploying procedures to increase customer value and provide profit for the organization [107,108]. A typical organizational ideation process for AI capabilities starts with mobilizing capabilities, where the digital business strategy is defined, and ends with deploying, which completes the process.

The goal of mobilizing is to determine all the capabilities needed by a company to gain a competitive edge. When the business environment is highly unclear, this is not a simple process. Businesses interested in AI technologies should determine what internal gaps they need to address and what external opportunities they need to seize [74,109]. This means that carefully evaluating which opportunities in the surroundings they are geared towards is essential before beginning to develop AI applications. This puts pressure on top-level managers to be able to strategically anticipate advancements and gain the technical expertise to be able to conceive ways in which AI technology might be applied creatively to address urgent concerns [3,45]. However, mobilizing calls for ongoing changes to the business’s processes, which can be difficult to maintain over time.

Integrating mobilized assets to produce capability configurations is the process of coordination. High-level managers are crucial because they have to coordinate the individual skills and knowledge of their teams, enabling quick, effective, and seamless integrations [9,86]. This means that in the context of AI deployments, any developed AI capabilities must be successfully coordinated and integrated with other organizational capabilities in order to implement the leveraging strategy effectively and create value [102]. For example, creating AI pipelines to make the effective processing of data and models possible requires a great deal of work. This means that in order to integrate an AI capability among others that will enable the firm to generate value, there must be open lines of communication and collaboration across various organizational units [14]. Here, managers play a crucial role because it is up to them to use their network of connections to combine various competencies into arrangements that add value.

The process of deploying requires actively assisting the leverage strategy [110]. Deploying requires integrating a machine learning model into a current production system so that business decisions can be based on data, such as a resource advantage, market opportunity, or entrepreneurial strategy [107,111]. Supporting a chosen leveraging strategy involves actually using capability configurations. Choosing an AI-oriented strategy and deploying solutions in accordance with it will result in diverse outcomes depending on the environmental setting in which such capability configurations are deployed in the context of AI deployments [84,112]. Because of this, there are many different ways that AI may be used within an organization, and the AI capability that a company manages to create can be coordinated and used alongside other capabilities to pursue digital business strategy [59].

Although it is predicted that the AI-specific technology needed to support projects will evolve extremely quickly, it is equally crucial to concentrate on other organizational resources that must be fostered in addition to the technology. The development of firmspecific, difficult-to-replicate AI capabilities requires these complementing organizational resources [14]. As a result, an organization’s capacity for AI might be defined as its capacity to choose, coordinate, and utilize its AI-specific resources. The study conducted by Ransbotham et al. [5] provides an exemplative illustration of the complementing organizational resources needed to gain business value through AI investments. While Davenport and Ronanki [33] point out that managers in more than a third of the studied firms do not grasp AI technologies and how they work, the previous authors remark that one of the most significant impediments to generating value is the absence of leadership to promote AI. As mentioned before, the significance of such supplementary resources has been stressed in a number of practice-based research. For example, Fountaine et al. [113] stress the value of encouraging inter-departmental collaboration and creating cross-functional teams with a variety of viewpoints and expertise. Organizations may make sure that AI projects take into account overall organizational priorities and not just specific business concerns by bringing analytics professionals together with business and operational personnel [102]. Additionally, by doing so, the applications for artificial intelligence that are created will be more in line with operational requirements [114]. As working with AI necessitates a completely new sort of skillset for both technical and management staff, developing the unique AI talents that firms need to build is another problem mentioned in numerous research studies.

# 3.1.4. AI Governance

There is a growing consensus on responsible AI governance, despite the lack of a precise definition [115]. It can be described as a function that details the various ethical rules that apply to AI. It may also be described as a procedure that spans all phases of AI project lifecycles by adhering to the responsible use tenets [35]. In particular, it is crucial to look at what kind of impact responsible AI governance has on businesses’ capacity to adopt changes in business products, procedures, and services and benchmark against competitive performance gains [44]. Microsoft, for instance, created explainability tools to comprehend machine learning models that support decision making [112,116]. Therefore, there is accumulating evidence to support the assertion that responsible AI governance affects internal organizational knowledge management skills [30], as well as how organizations are perceived by external entities when utilizing AI [35].

AI is influencing more and more facets of society, including marketing, healthcare, and human rights. It would not be a good idea to permit the development of unsupervised AI applications [39]. Therefore, it is crucial to advance a reliable AI that abides by the law and is moral, ensuring that ethical principles and values are upheld, and is reliable from both a social and technical perspective. Depending on the viewpoint of each person, governing AI initiatives may be regarded differently. While the European Commission (EC) and Singapore principles view AI governance from a trustworthy stance where solutions are human-centric, Microsoft researchers view AI governance from a technical perspective [115]. The seven ethical AI principles, as outlined by the European Commission, are depicted in Figure 4.

# Governance Mechanisms

Different mechanisms can be used by businesses to govern AI [52]. They include formal frameworks linking business, IT, data, model, and machine learning functions, formal procedures and processes for decision-making and monitoring, and further practices encouraging stakeholder engagement and collaboration [34]. We separate governance methods into three categories: Structural, procedural, and relational in accordance with the IT governance literature [115].

# Structural Mechanisms

Reporting frameworks, governing bodies, and accountability are defined by structural governance processes [117]. They consist of the distribution of decision-making authorityations [39]. Therefore, it is crucial to advance a reliable AI th along with roles and duties. Although there is a wealth of work on data governance [32], there is not as much on AI governance [106,113,118].

The development of AI systems involves many different disciplines [119]. In order toand technical perspective. Depending on the viewpoint o manage the complicated interplay between model outputs, training data, and regulatory initiatives may be regarded differently. While the Europea and business needs, it may be necessary to construct an inter-disciplinary AI governance council that has been proposed for AI in healthcare [106]. Executive sponsors are also vitalpore principles view AI governance from a trustworthy sta to the process [3]. Depending on the company’s adoption level, the executive sponsor’s level of power and decision-making over performance objectives may vary. For instance, a dedicated AI budget without any performance requirements would help adoption, at seven ethical AI principles, as outlined by the European C least in the early stages [108]. Investigations into more precise roles connected to model elements are still ongoing.

![](images/824e121577a9a8f45fc94390f5ff167fae569a878213961f01b56cb43c5e850f.jpg)  
Figure 4. AI responsible principles based on European Commission. Source: Own elaboration.

Procedural mechanisms

The goal of procedural governance mechanisms is to guarantee that AI systems and ML models function effectively and accurately, that they will be held securely, and that their operation complies with all applicable laws, regulations, and company internal rules and policies regarding explainability, fairness, accountability, security, and safety. Ensuring data, eworks linking business, IT, data, model, and machine learninmodel, and system-relevant features and is another goal of procedural methods [119]. Individually and collectively, they include (1) a strategy, (2) policies, (3) standards, (4) processes and procedures, (5) contractual agreements, (6) performance assessment, (7) compliance stakeholder engagement and collaboration [34monitoring, and (8) issue management for data, models, and systems.

Based on strategic organization goals, the strategy indicates high-level guiding of actions. The study by Keding [27] focused on where AI and strategic management interact, with a ce literature [115]. particular emphasis on two aspects: (a) Antecedents, such as data-driven workflows (data value chain and data quality), managerial willingness, and organizational determinants (AI strategy and implementation); and (b) consequences of AI in strategic management on a personal and organizational level (e.g., human–AI collaboration, AI in business models) [119]. The work focuses on using AI for business intelligence-related decision-making within an organization. A number of AI strategy-related components are currently being worked on, including guiding concepts by academics and practitioners [118,120,121].

High-level standards and norms are provided by AI policies. Key objectives, accountability, roles, and duties are all communicated by organizations through AI policies. Politicians are actively debating AI policies. For instance, the European Union has presented policy options on how to promote the use of AI while minimizing hazards, and a portion of them has already been included in a proposal of the 2021 European Commission [115]. Best practices could be a source for policies at the corporate level [122]. The measurement of (public) AI policy is a hot topic that is also the subject of ongoing discussion and study. For instance, Mishra et al. [31] cover the measurements of AI’s societal and economic impact and the dangers and threats posed by AI systems. While there has been significant progress in the development of data standards, there has been less progress in the establishment of AI standards [119]. Examples include Wellbeing metrics for ethical AI (IEEE P7010), Benchmarking accuracy of Facial Recognition Systems (IEEE P7013), Fail-Safe Design for AI Systems (IEEE P7009), and Ethically Driven AI Nudging Methodologies (IEEE P7008).

In accordance with ISO Standard 9000, a process is defined as a set of interrelated or interacting activities, which turns inputs into outputs, while a procedure is defined as a predetermined technique to carry out an activity or a process [119]. We think of processes and procedures in the context of governance as standardized, recorded, and repeatable ways. AI procedures can be regarded as an essential component of the effective deployment of AI governance [112]. They are related to procedures connected to ML and AI systems and procedures for data governance [123]. The cross-industry standard process for data mining is frequently used in the building of ML models while software engineering coding standards can also act as a governance tool. A similar governance tool for AI to promote interoperability may include defining and enforcing model and system architectural principles, documentation, and coding norms with the aim of improved composability and maintainability [32,39,119]. The recording of each feature, along with its justification, is considered to be the best practice.

Furthermore, more suggestions have been made using software engineering as a guide [3,67]. Some draw generalizations from a case analysis describing the application of ML to address transaction errors, whereas others rely on surveys conducted within a single organization [119]. The ideal method is still a topic of contention, though [67]. As mentioned in [119], the examination of model governance has highlighted procedures for model validation, control, and evaluation (e.g., review policies, updates, and security) [119]. Significant focus has been placed on ML assurance, that is, carrying out an ML development process that produces evidence for the model’s safety, as well as testing techniques for ML systems [124]. Overall, research on models and AI techniques is generally lacking.

Contractual arrangements between involved internal departments or outside entities may concern data, models, or AI systems. Models contain information about the training data that could be taken and utilized improperly in a number of ways, such as by competitors to lower data labeling costs [119]. By precisely defining the operational parameters of AI, contracts also play a significant part in lowering the risk of liability [106,125]. In situations that are unexpected and counterintuitive to human logic, AI may malfunction. Operational concerns therefore necessitate explicit legal notices. Additionally, traditional risk management strategies for AI have been proposed [126]. Monitoring compliance ensures that organizational rules, standards, processes, and contractual commitments are carried out and enforced. The European General Data Protection Regulation (GDPR), which has an impact on data and models and provides the right to model decision explanations, is one of the most notable rules [9,119,125,127]. AI-related issues are identified, managed, and resolved as part of issue management. This covers procedures for standardizing data concerns and their resolution, designating individuals to handle issue resolution, as well as an escalation process [123].

# Relational Mechanisms

Collaboration amongst stakeholders is facilitated through relational governance frameworks. They encompass (1) communication, (2) training, and (3) the coordination of decision-making [128]. A collaborative development platform should be used to facilitate communication within an interdisciplinary AI team. Technical and business knowledge are crucial AI competences, according to Mikalefand Gupta [14]. Thus, employee training is $\mathrm { { \mathbf { u } } } ^ { \prime \prime }$ deniably crucial. While training is frequently associated with learning how to use AI, it can also mean preparing staff members whose duties AI may automate or augment in order to reduce unfavorable effects [129]. Using communication to convey a company’s aim to deploy AI as an augmentation tool rather than a replacement could help alleviate employees’ anxiety [129]. In comparison to data governance, ML models and AI system governance are generally poorly understood [117,123].

It is asserted that academics who studied IT governance and data governance in the literature already in existence offered frameworks or procedures for enhancing functionality or reducing hazards brought on by AI [119]. However, there is a void in the governance of AI, which directly affects AI and deals with both IT governance and data governance [62,130]. As a result, research on how to implement AI governance would be of great benefit, as would knowledge of improving organizational performance while ignoring the drawbacks of AI use [43].

Responsible artificial intelligence application development has advantages from an ethical and moral perspective as well as the potential to give organizations a medium- to long-term competitive edge [131]. For instance, a business can attract technical specialists and keep top talent by demonstrating its dedication to ethical standards, especially in times when competent developers are hard to find. According to the EIU research, unethical business practices deter potential candidates from applying and erode their confidence in the sector, which contributes to the so-called “techlash”, which is the outcome of public skepticism and hostility against major tech businesses [115]. Moreover, ethical AI policies and procedures make it possible to document how a company handles artificial intelligence-related problems [131], which aids in the identification of prospective operational problems or business opportunities [112]. Because reliability increases customer retention, expenditure, and uptake of new services, responsible AI starts to have an impact on performance [14,132]. By upholding moral and responsible standards, an expertly designed AI application can protect and grow one’s clientele [131]. Businesses will be able to retain clients and boost their credibility by creating inclusive products and services that are efficient for all customer types, assure safety, and are transparent. Customers’ trust difficulties, for instance, may be resolved with the adoption of blockchain technologies in AI services for traceability and transparency [132]. From a compliance standpoint, it is equally crucial to building responsible AI governance. Authorities have started keeping an eye on artificial intelligence applications and creating rules that incorporate standards and ethical considerations, such as auditing procedures and algorithmic effect analyses. As a result, a variety of frameworks for protecting personal information and privacy now incorporate privacy by design into their structures [125].

The idea of responsible AI governance has seven components. Accountability, environmental sustainability, societal well-being, transparency, equity, robustness and safety, data governance, and human-centric AI are some of these dimensions [112]. Since it takes a great deal of work to develop a responsible AI governance system, one of its main goals is to lessen the potential that a small change in the weight of the input can significantly modify the output of a machine learning model. To ensure that a company is committed to creating objective and dependable AI, continuous evaluation is required [119]. Therefore, having a maturity model or set of standards to adhere to is crucial for a business while developing and implementing an AI system. The role of knowledge in enhancing an organization’s performance is crucial, as is the organization’s capacity to successfully adapt the information for future use and respond to environmental changes [90].

The performance of an AI application should be evaluated both before and after deployment by an organization that employs responsible AI governance [35]. The ability to explain the data and AI governance aspects clearly and concisely, as well as their interactions, is also crucial [12]. For instance, it is important to record every step of the data processing process, from data collection to use [133]. Since documented processes are less likely to become obsolete, documentation also reduces reliance on a single person’s expertise. Responsible AI governance also emphasizes inclusive design and the development of human agency and autonomy. These are essential elements for improving the use of human capital inside businesses and, consequently, maximizing knowledge exchanges and relationships. Finally, appropriate AI governance mandates that a high emphasis be placed on the security and dependability of entities and systems that communicate with AI agents throughout the design, implementation, and monitoring of AI applications [71,134]. By establishing such privacy and security regulations, cross-departmental access and knowledge sharing are made easier without running the danger of sensitive information being leaked or accessed by unauthorized employees [135].

# 3.2. The Integration of AI and Business/IT towards Digital Transformation Alignment for Enhanced Business Value Outcomes

# 3.2.1. The Road to Strategic Flexibility

While the proactive aspects of strategic flexibility seemed to be less prevalent in the existing body of knowledge, scholars defined and operationalized it primarily as a rather reactive ability to satisfy environmental demands [21,136,137].

This study adopts a broad and comprehensive understanding of what strategic flexibility comprises, in keeping with Raynor’s paradigm for strategic flexibility as presented in [138]. As a result, the existing literature may be used to identify four essential components of strategic flexibility that together give rise to the idea of dynamic capability [139]. These components fit with strategies for resource deployment, competitive actions, and proactive and reactive capabilities [37,136,140,141]. Strategic flexibility is a multifaceted idea as a result. These four components are (1) anticipating change drivers and future options [43,136,140,142,143], (2) formulating and designing strategies [137,140,144,145], and (3) assembling and developing capabilities [95,136,144,146,147].

# Anticipating Drivers of Change and Future Options

The first factor focuses on the organization’s ability to describe many potential business futures and scenarios based on drivers of change. This theoretical aspect of strategic flexibility essentially charts a path between foreknowledge (denying uncertainty) and paralysis (excess ambiguity) [21,138,148]. For instance, scenarios assist organizations in thinking more flexibly about the future so that we can respond more quickly to changing circumstances. By forcing organizations to think deeper into the future than they normally would and forcing decision-makers to consider new options, they also promote innovation and creativity [20,136]. Thus, the first component aids in comprehending the driving factors, interactions, and changing dynamics at play in the business environment.

# Formulate and Design Strategies

The ability of the organization to assess ideal strategies in order to identify essential and potentially necessary contingent parts is the focus of the second aspect of strategic flexibility, which is the formulation and design of strategies. Consequently, when a company does so consistently, this will lead to decisions about how to produce value and build clear accountability for results [9,145]. Decision-makers can use a surgical approach to data collection and analysis based on future alternatives and scenarios, and they can then concentrate on addressing important uncertainties to support decisions and foster action commitment [144,149].

# Assemble and Develop Capabilities

The third component, “assemble and develop capabilities”, involves acquiring or choosing the capabilities required to carry out the core plan. In order for businesses to be able to adjust to changing client and market demands, they must speed up the development of their adaptable capabilities [2,13,138,148]. In order to effectively develop organizational skills and support structures, processes, decision rights, performance indicators, and adaptive mechanisms, the organization must plan a relevant set of enhancement activities [9,147]. To enable a successful change endeavor, decision-makers and leaders must alter their ways of thinking and acting [146]. In the end, this will make it possible for companies to prepare for and react to quick, complicated changes in the environment [95]. Additionally, change programs that support rather than restrict the organization’s capacity for adaptation are more likely to result in long-term success [150].

# 3.2.2. The Role of AI in Strategic Components AI in Strategic Analysis

The potential of AI to improve and change strategic analysis is a place to start when investigating the role of AI in the strategy process. Despite the fact that managers have long relied on information systems to help them gather and organize data for environmental scanning and decision-making [128], AI algorithms may have the potential to significantly increase the scale, scope, and speed of analysis of an organization’s external and internal environment. This is because AI algorithms are capable of interacting with the environment and generating data. According to previous studies [66], AI can specifically help with (a) gathering data from internal and external sources on a discrete or continuous basis, (b) analyzing and interpreting that data through pattern identification, and (c) supporting executives in making decisions through predictive analysis. As a starting point for mapping how AI may support strategic analysis, we first discuss its applications for analyzing external (i.e., macro- and micro-environmental) factors. Next, we consider AI’s role in competitor analysis, and, subsequently, in the internal analysis of human, financial, and auxiliary resources.

Concerning external analysis, the strategic appraisal of political, economic, social, technological, environmental, and legal variables has been impacted by AI applications [3]. The “political environment” across regions can be inferred using a variety of AI-based text analysis technologies created by political scientists. Such systems examine several data sources, such as news organizations, parliamentary proceedings, and online political dialogue. More specifically, unstructured social media data analysis using ML algorithms has proved successful [53]. Election results, policy changes, political bias, and conflicts can all be predicted using such data, according to research such as that of Chan and Zhong [151]. With AI, political trends and events may be identified and predicted early on, giving strategists a competitive position by enabling them to better grasp how the government and government policies may affect their business. Additionally, ML can be used to quantify economic patterns precisely and consistently, such as economic growth, the beginning of economic recessions, rising poverty, and bankruptcies [63,66]. The financial services sector’s embrace of ML tools is a crucial step before strategists can use them. In order to improve their investment decisions, institutional investors, for instance, employ ML to forecast stock returns and calculate systemic financial risks [152,153].

Changing demography and societal values are only two examples of social elements that strategists frequently need to consider in their analysis. While some of these changes may be gradual (such as those in national culture), others are prone to abrupt upheavals and quick changes (for example those in fashion), which may present important possibilities or risks to the organization [106]. To “map the contours of cultural fields, classify cultural materials, and follow the evolution of culture over time,” scholars have suggested methods such as automated text analysis [154]. Additionally, new algorithms allow for the systematic measuring of culture and the modeling of its development within social groups and organizations [27,86]. Such advancements provide new possibilities for strategy research’s measurement of challenging notions such as culture. From another standpoint, whether for manufacturer or user firms, researchers frequently assign technical elements a significant part in most strategic analyses [66]. AI can help businesses keep track of technical advancements and foresee any important technological changes. For instance, by sifting through enormous volumes of patent or publication data, AI is increasingly utilized to uncover trends of technological advancement [155]. These AI applications enable businesses to create “knowledge profiles” of their market and key competitors [156].

Ecological and environmental considerations are gradually becoming more important in strategic analysis due to the increased climate change awareness and the focus on corporate sustainability responsibility (CSR) [56]. Though research on the use of AI in this type of study is still in its infancy, there are encouraging instances, such as studies exploring whether hydrogen electrical vehicles might evolve into the most popular mode of consumer transportation [86]. Such applications are crucial for both commercial investors and policymakers who are choosing where and how to build transportation infrastructure. Organizations usually invest a great deal in legal advisors who frequently manually compile and assess a big body of current legislation that may change the terms of business across countries and legal regimes [39]. Applications of artificial intelligence may assist in the internal collection and processing of such legal data by businesses, potentially lowering overall legal costs. For instance, an AI algorithm that sorts through thousands of pages of legal papers can offer helpful summaries pertinent to a firm’s strategy [66]. AI is also rapidly being utilized to automate financial compliance monitoring and regulation [157].

Competitor analysis is a key area where AI is used in strategic analysis. Automated analysis can assist in grouping data, spotting trends in data, and even forecasting competitors’ strategic movements as businesses amass enormous amounts of data regarding their competitors and their industries. Strategists frequently have to identify pertinent competitors in order to move forward with strategic analysis, yet doing so continues to be one of their most difficult tasks [86]. There are new methods for spotting upcoming competitors and forecasting performance, such as studying online content to determine the “correlation” or convergence of the organization’s services and product offers. Similarly, AI algorithms can be used to identify strategic groupings made up of businesses with similar strategies and estimate the transit of businesses within and between these groups [66].

All these tools also provide a more dynamic method for performing competition analysis [142]. Indeed, academics have cautioned that in order to assess the ongoing validity of an organization’s strategy, assumptions about competitors must be periodically re-examined and assessed [86]. The advantage of automated competitor analysis over conventional, manual, and discrete approaches is significant: Once connected to machines that generate market and competitor data, such as web crawlers and online sales, algorithms can carry out competitor analysis continuously and aid strategists in dynamically evaluating the viability of the organization’s current strategy.

Additionally in terms of internal analysis, AI may support the strategic analysis of organizational internal elements, such as staff, budgets, and auxiliary resources, including supply chains or customer relationships [132]. AI applications can help managers detect employee performance, anticipate career paths, and uncover patterns of compensation and inequalities, including other things, by automating pattern recognition in such data, starting with human resources [10]. Strategists can more accurately gauge the degree to which a possible strategy can be implemented by carefully evaluating abilities, knowledge, aptitude, and demographics.

Furthermore, organizations have vast amounts of detailed, precise, and categorized accounting and financial data. When performing an analysis, strategists frequently use balance-sheet data, for example. AI algorithms can analyze patterns by constantly or discretely clustering collected data. By performing this, algorithms can improve the interpretation of what drives specific financial resource conditions that are pertinent to the nature and timing of the firm’s strategic commitments, such as fluctuations in liquidity and exchange rate premiums at company budgets [45,158]. AI can also be applied to financial studies that are less crucial to the formulation of strategies, such as tools for keeping track of business transactions [157]. Applications are able to quickly spot fraud by detecting transactions with unusual quantities or frequencies. With the help of these tools, AI can help manage financial risk by enhancing compliance and risk management activities with better data-driven insights, utilizing quick and automated data analysis, and reducing administrative burdens, freeing up the time of finance and accounting staff members for more inventive tasks [142].

A variety of additional resources crucial to the strategy process, such as demand forecasting, production planning, resource allocation, and logistics, are increasingly being analyzed with remarkable efficiency using AI algorithms. AI can enhance production planning decisions, for instance, by automating the procedure of choosing qualified suppliers by mining data from online directories and other repositories [9,128], offering forecasts on the performance of potential suppliers [159], and even estimating valuation and evaluating online bids [160].

Moreover, a complementary resource that is particularly pertinent for AI-supported analysis relates to customer relationships. Customers are participating in more productand service-related discussions, consuming digital information, and exchanging expertise on a range of social media platforms [161]. Strategists can better understand patterns and seasonality in consumer needs connected to their service and product offerings by keeping track of customer behavior through their digital footprints [132]. Such information can then be used to anticipate customer preferences, which will eventually result in an analysis important to the company’s product creation [162].

# AI in Strategy Formulation and Implementation

Many firms have made AI the focal point of their high-level strategy in light of its quick ascent to the status of general-purpose technology. In the I/0 2017 keynote, Google CEO Sundar Pichai stressed the company’s policy of putting “AI first”, emphasizing a greater outlook on ML and other AI technologies to boost organizational efficiency and enhance customer experience [66]. In the years that followed, Google and its business partners made significant investments in products that appeared to be more “intelligent,” such as Google Photos, which uses AI to identify people, places, and objects in images, RankBrain, which speeds up searches, and Google Assistant, a personal virtual assistant. All of these moves significantly raised the company’s overall valuation.

The activities that make up the formulation and implementation stages of the strategy process are also changing as a result of AI. Organizations set business development and financial targets, as well as associated execution strategies, at varying levels of granularity in their pursuit of profitable growth [157]. Formulating and implementing a strategy is a protracted and complicated process involving a significant amount of varied data and draws on managerial analysis and decision making at various levels of the organization, regardless of whether such a process occurs frequently and formally or infrequently and informally [9,12,34]. Therefore, the cognitive constraints of strategists in processing data for the decision-making and problem-solving tasks underlying strategy formulation and implementation are extensively documented in the literature [66]. Discussions regarding the development of earlier generations of decision support systems since the 1950s are strikingly similar to those surrounding the potential of AI to improve human strategy formulation and implementation.

On the one hand, scientists appear to agree that big data and modern AI applications outperform the capabilities of earlier systems. In-depth understanding of the firm, its environment, and the risk–reward profile of strategic options is necessary for effective strategy formation [106,163]. Similarly, a strategist’s skill to efficiently monitor operations and assess the effectiveness of strategic activities is essential for successful strategy implementation [59]. Therefore, the ability of AI system applications to optimize continuous data analysis, generate new information about strategic opportunities, and recognize patterns to foresee the outcome of choices stands to improve the quality of the strategist’s decisions where they relate to formulation and implementation tasks, which require primarily knowledge assets [27,30,63].

On the other hand, there are several reservations regarding the limitations of AI systems in the development of strategy. For instance, researchers have made the argument that while AI performs well in stable, context-specific settings, it underperforms in settings that involve creativity, novelty, and uncertainty [12,62,164], and it can even increase complexity in overall organizational decision making [66]. As a result, AI is better viewed as a “helper” that improves strategists’ ability to make decisions concerning external threats and opportunities, internal strengths and weaknesses, and strategic challenges [60,73].

# AI and Corporate Strategy

We consider its function in the study of typical corporate-level strategy concerns pertaining to a firm’s business portfolio and decisions regarding growth and diversification to provide an example of how AI can be employed in certain areas of strategy formulation and implementation [165]. A business portfolio of enterprises can be evaluated for fit, risk, and performance using artificial intelligence, and potential synergies between them can be analyzed and suggested [159]. AI can help strategists address portfolio risks, for instance, when demand swings are highly connected throughout the portfolio or when multiple firms are subject to comparable currency risks, based on an examination of market and product data across business units. Such AI “sparring partner” activities are referred to as “cognitive insight” by Davenport [29].

AI technologies are also changing how businesses identify and evaluate potential merger and acquisition prospects as well as how they handle the deal cycle and post-merger integration phase. Traditional mergers and acquisitions (M-A) are bound to monitor a limited set of potential targets because they call for a variety of resource-intensive analytical activities, due diligence, market analysis, valuation, and pricing, but AI-based analytics enables businesses to display a big pool of opportunities automatically and constantly as they present themselves [5,86]. Automatic document summarization and topic modeling are two examples of natural language processing (NLP) techniques that can be used to create a filter that will preselect appealing situations for further human consideration [66]. The advantage of artificial intelligence in these situations comes from the technology’s capacity to integrate a variety of data sources, including patent databases, organizational financial records, previous M-A deal data, and social media, for example, LinkedIn data, in order to identify rare skill sets, news media, conference call document filings, and discussion forums, and dynamically adapt screening criteria to shifting environmental conditions [166]. For instance, Refinitiv, a San Francisco-based provider of emerging financial technology solutions, uses AI techniques to create predictive quantitative models on M&A targets that assist decision-makers in more correctly estimating synergies and evaluating deal value [34].

Furthermore, given the importance of speed and efficiency in decision-making regarding M&A opportunities [167] and the post-merger integration stage, AI can have a significant impact on performance by automating acquisition process steps and narrowing crucial M&A cycle activities [109]. Additionally, these tasks could be carried out more cheaply. For instance, with regard to the pre-acquisition stage, transactional law has made significant strides in recent years, allowing legal practitioners to streamline the labor-intensive M&A due-diligence process. Among the many uses for AI, automation can help target companies gather and categorize pertinent documents more effectively while ensuring they adhere to disclosure laws [168].

Post-acquisition, by merging vast expanses of unstructured data from different enterprise systems, such as those found in customer databases and contract repositories, AI may further enhance and speed up job integration and uncover potential for cost reduction. Similar to this, AI may have uses in cooperative strategies such as partner selection and identification in strategic alliances. Indicators such as a potential partner’s company emphasis or strategic orientation, for instance, may be found by strategists using NLP on annual reports [169].

# AI in Strategic Innovation, Entrepreneurship, and Renewal Models

It is becoming clearer how opportunities and obstacles for launching new businesses and strategic entrepreneurship may arise from the adoption of AI technology by businesses. A general-purpose technology (GPT) as a new way of creating, AI, and particularly deep learning, has the potential to change the structure of the R&D process and the nature of the innovation process [1,20,170]. They contend that improvements in AI result in a reinforcing loop between innovation at the level of AI and its application sectors, similar to the growth of previous GPT such as the microprocessor.

According to Chalmers, MacKenzie, and Carter [171], there are three ways that AI might improve the information-search and idea-generating processes that form the cornerstone of discovering and seizing new business opportunities. First, the capability of deep learning algorithms to locate structures in high-dimensional data enables corporate and start-up entrepreneurs to look for and test previously unobservable prospects [165]. Second, AI can encourage the creation of new businesses by identifying and capitalizing on consumer demands [132]. Third, AI-based simulations and trials offer financiers and company executives the chance to put fresh ideas and ventures to the test. For instance, simulations employing dynamic real-world data might mimic the circumstances that new businesses might face in the future [165]. When completely developed, such tools might not only be useful for investment decisions but also for designing innovations and making decisions on crucial product characteristics such as pricing or marketing [20,34]. Entrepreneurs could thus put their ideas to the test, forecast how buyers would respond to certain product features, and make adjustments to product design and pricing using AI-based simulations and trials [171].

Through the development of conversational systems and robotic sales advisers, AI is also making progress in assisting and supplanting human activities in tasks connected to the exploitation of new business ideas [171]. It is yet unclear how valuable these solutions will end up being in the long run. Questions about the effects of organizational de-skilling and a loss of client relationships as a result of robo-advisors, as well as concerns about customer acceptability of contact with AI-based systems, will present new study opportunities in the future [132]. Important questions about how AI-based technology affects strategic entrepreneurship when it comes to expanding new businesses and controlling the risk involved in entrepreneurial activity arise from a strategy perspective.

# AI in Strategy Control

Strategy control refers to the actions taken by strategists to make sure that the execution of strategic plans proceeds as planned and to track the achievement of strategic objectives. Despite its necessity, there has not been much research on using AI for strategy control [66]. Nevertheless, due to the ability to automatically identify appropriate performance criteria, track and assess performance against standards, and recommend paths for corrective measures based on predictive analysis, various viable areas can be found. The use of AI for project management and internal communication is particularly intriguing. AI will become an important tool for assisting strategists in assessing the implementation and performance of their strategies as more and more commercial operations are managed through increasingly interconnected digital platforms [90,159].

# 3.2.3. AI Business Value Drivers and Enhanced Outcomes

So far, a variety of business value outcomes have been proven to be enhanced by the implementation of AI technologies in organizations’ schema but we are still at the very beginning of this new technological era. Despite the fact that little knowledge is, as yet, robust from both a theoretical and technical viewpoint, there are remarkable studies on AI and Business Value Streams in organizations. Prior research [91,172,173] examined how

IT resources affected higher-level organizational capacities, but there has not been much attention paid to developing intermediate capabilities in the context of AI [74,174]. As a result, businesses should adopt an ambidextrous viewpoint while utilizing AI in practice, whereby routine and novel uses of AI simultaneously fuel the growth of the organization’s strategic flexibility.

Though it might not be as simple as one might imagine, obtaining economic value from AI ambidexterity may be a challenge. First, given the company’s adoption and progress of AI, routine and innovative usage of AI may vary from one organization to the next [89]. According to the literature, AI should be used as a crucial organizational resource to build the dynamic capabilities of the organization so that it can reach its full potential [42,175]. A critical dynamic capability and strategic flexibility thus evolved as a result of the simultaneous strategic emphasis on these two fundamental features of AI ambidexterity [139]. This is also consistent with the claims made by [72,176], who assert that the strategic flexibility of an organization is often significantly impacted by the application of analytics and AI in action. By anticipating key change agents and potential future business scenarios, AI ambidexterity especially enables enterprises to forecast market trends, better understand the challenging environment, and respond appropriately, giving them the very first advantage [37]. The framework for developing data- and AI-driven business plans and scenarios that encourage commitment to action is provided by the ambidexterity of AI for businesses [13,149,177].

Additionally, AI ambidexterity simplifies the ability of enterprises to coordinate and mobilize their resources, skills, and previously unrelated capabilities [37,63]. Additionally, AI ambidexterity gives businesses the resources they need to reinvent their work processes with the help of cutting-edge intelligent technologies and algorithms [177]. Finally, by empowering decision-makers to innovate [8,72], roll out or align business alternatives all around the organization, and possibly enter new business sectors [5], the organization will be able to constructively perform the business strategy. Utilizing these ostensibly incompatible and competing AI application modes means firms are better able to detect and foresee changes, respond proactively to them, and align business and IT strategies. The accepted complementary view on the capabilities of AI goes beyond a structural and temporal focus and highlights the dynamic and interconnectedness of AI’s routine and innovative use as a key factor in what motivates organizational strategic flexibility [21]. In reality, it is entirely possible that novel applications of AI, and hence the exploration mode, come before standardized methods of using them [8,75].

Many academics contend that strategic flexibility develops a portfolio packed to implement a variety of contingent strategies and motivates the organization’s IT and business resources to be renewed in order to achieve operational capability-level efficiencies, business/IT alignment, quality improvement, and innovativeness [70,95,138,146,147,173,178]. Additionally, strategic flexibility enables firms to restructure and improve operational practices and capacities and accelerate the adoption of digital technologies [2]. Moreover, strategic flexibility enables organizations to create the best possible business strategies and the skills required to implement the core strategy. Furthermore, it might improve their operational ambidexterity or a dual digitalization framework to operational capabilities, or their operational exploration and exploitation capability [13,138,148,179]. Therefore, companies need to be strategically flexible because they must reassess their current operating models and adapt as quickly as their environment, especially in the face of a pandemic such as COVID-19 [146,180–182]. Therefore, this study conceptualizes that the alignment of AI Capabilities and Business/IT strategy enhances several business value outcomes for organizations [51,109]. This is in line with the extant literature on the IT-business value process [173], leveraging IT ambidexterity and AI capabilities in organizations [13,14,76,109].

Change projects that support adaptive transformation skills rather than stifling them are more likely to yield lasting effects [13]. Unfortunately, as firms undergo transformation processes, numerous impediments become ingrained in them. Consider, for example, disgruntled workers, stubborn decision-makers, and routine processes [34]. The extended leadership team is engaged by adaptive transformation capability, which also helps reshape the organization, its management, and its resilience [5,86]. Adaptive transformation capability addresses such roadblocks to transformation and directs businesses in orchestrating balanced transformation alignment. An adaptive transformation capability, as a strategic capability, enables businesses to stabilize the transformation roadmap and acts as the pillar to achieve high performance in turbulent times [34,90]. This dynamic flexibility, which is supported by AI capabilities, enables businesses to swiftly coordinate the beginning of the subsequent development phase and carry out essential adjustments [21]. With a high level of participation, businesses make sure that long-term improvements drive competitive performance and produce ground-breaking outcomes in challenging times [37,159].

To summarize everything said above, we offer a conceptual model that outlines all the aforementioned relationships. In Figure 5, which was modified based on the prior portions of important literature, the streams for enhanced value outcomes in the integration of AI in business/IT strategies are graphically represented. This framework was specifically27 of 45 designed to help managers assess the competitive value of complex AI investments while also taking a strategic stance on the anticipated connections.

![](images/3eb959dd5461a30394ea2daf19e60b87ce110e72d604348dcbfe6af159172093.jpg)  
ramework. Source: Own elaboration.Figure 5. Conceptual framework. Source: Own elaboration.

# 4. Discussion

In order to help businesses align with their digital transformation and deliver improved business value outcomes, the integration of AI with business/IT strategies was the focus of this study. Artificial intelligence research is fundamentally sparked by digital ue outcomes, the integration of AI with business/IT strategies was the transformation, extremely difficult problems, and businesses’ need to model and compreArtificial intelligence research is fundamentally sparked by digital hend human behavior. The significance of management information systems, located at the intersection of information, business, and industry, has grown even more as a result of the fourth industrial revolution, particularly now that digitalization has grown into a necessity.

The significance of management information systems, located at We conducted a systematic literature review using a particular technique that has nformation, business, and industry, has grown even more as a result been widely utilized in the past to investigate information systems strategy and subjects related to digital transformation. Our research indicates that an organization commonly undergoes a digital transition as a result of environmental technological developments. It is now urgently necessary for the organization to be able to connect with its surroundings a systematic literature review using a particular technique that has and follow new regulatory frameworks. Simultaneously, the integration of AI capabilities with business/IT strategy has been highlighted as one of the key enablers of digital transformation alignment, which improves a variety of organizational business value outcomes. Specific difficulties, solutions, levers, and streams can be found in the context of responsible AI governance and the use of its ambidexterity in the development of AI capabilities. Anyhow, to be able to provide enterprises with a significant competitive edge, applied AI capabilities in conjunction with strategic flexibility unlock new routes of value creation that must be evaluated from various complex viewpoints.

The study’s findings present a more detailed picture of how AI affects organizations. Previous research has demonstrated how the application of AI can help organizations acquire the adaptive organizational capabilities necessary to increase operational efficiency. This study, which is in line with past studies, demonstrates the critical role AI capabilities play in enabling the integration of digital transformation alignment, which ultimately generates a competitive advantage. As a result, this study reveals the enablers and drivers for pursuing AI’s increased business value. This study also demonstrates that the synergistic ambidexterity effect outweighs the sole benefit of creative and consistent AI utilization. This result demonstrates the need for organizations to have a dual strategic focus on innovative and routine AI deployment, as these two essential facets of AI ambidexterity have a synergistic impact on the strategic flexibility of the organization.

Additionally, these revelations contribute to our understanding of the ways organizations must optimize their AI resources to promote strategic flexibility and benefit realization at the strategic level of the organization and contribute to the current body of knowledge on shaping and developing dynamic capabilities. Additionally, our current research suggests that by establishing digital skills that are challenging to compete with, businesses can traverse challenging and shifting business environments. Our research thus adds to the body of knowledge already in existence and satisfies the demand for additional fundamental studies on AI’s role in strategy. By doing this, we draw attention to how AI capabilities help businesses to be more adaptable. Additionally, the results of this study refute the notion that because AI has such a long life cycle, it is frequently monolithic and unable to adjust to changing surroundings. What is crucial, however, is for businesses to use AI to support adaptive transformation as opposed to impeding it.

In addition, the policies and objectives that define and steer the company strategy should take into account whether good AI governance has a direct impact on an organization’s results. The failure to comprehend how the unintended effects of an AI system could affect a firm’s overall competitive position is crucial to the creation and adoption of responsible AI regulatory frameworks that enhance economic value. Therefore, learning about and researching the proper operation of responsible AI governance frameworks could give businesses an advantage over their competitors. Managers who want to include ethical AI issues in their work must first understand what is required to do so before taking the necessary actions to create an ethical AI system. It is a significant task to reorganize organizational structures, allow a way for responsible AI research, and then implement management reforms to put new organizational practices into place in the absence of an AI governance framework.

Understanding that operational ambidexterity is driven by strategic flexibility, which leads to the simultaneous innovation and development of operational business systems and practices using digital technology, is another significant theoretical contribution. This result builds on previous research and demonstrates the critical role AI plays in attaining these operational gains. These findings can be used as a springboard and vision for IS and management researchers who want to look into the business usefulness of AI capabilities.

Numerous practical implications of this research are also present. First, policy makers need to make a concerted effort to invest in AI and highlight the creative and rather numerous ways it is already being used. The emergence of the strategically flexible organization will be fueled by the synergistic impacts of these ambidexterity actions in this manner. They ought to concentrate on a continuous capability-building process and plan. This suggests, for instance, that decision-makers inside the business should place an emphasis on seeing the AI issue via a more holistic approach, which further regards technology as a key element of competitive strategy. In order to create and further shape dynamic capacities to look ahead, inform and optimize decision-making, and respond to shifting market conditions and demands, businesses should actively invest in AI skills. These actions will guarantee that the organization develops a competitive edge, achieves high levels of organizational performance, and refocuses on a number of strategic growth and performance improvement objectives.

Second, top management should make use of AI to increase the organization’s strategic flexibility. The firm can take measures to promote and mature this dynamic capability and fuel its operational ambidexterity by structuring improvement activities anywhere along lines of the fundamental components of strategic flexibility. Organizations might, for example, create and test strategic alternatives and decisions based on numerous conceivable future circumstances. The organization’s skill to notice, respond to, and thrive on disruptions and changes that occur within the ecosystem throughout time can be increased by acting in this proactive manner and practicing for many futures. High organizational levels of learning and collaboration are other advantages of doing this. Organizations must create the best possible strategies for the chosen business situations and determine what is required, in keeping with the second aspect of formulating and designing strategies. With distinct responsibilities and decision rights to guarantee high-quality and prompt decision making, the process should result in targeted investment decisions. Decisionmakers should achieve this by identifying and managing diverse thinking and assumptions through fruitful discussions and meetings with different stakeholders. Additionally, wellformulated and well-designed strategies often concentrate on standard measures that create business value throughout the organization and guarantee unambiguous accountability for results. Likewise, organizations need to establish the ability to change more quickly in order to adapt to shifting consumer and market demands. In doing so, decision-makers need to take into account the interdependence of variables including the amount of available human resources, the time frame, and the strategic goals. In order to effectively develop organizational capacities and support structures, processes, decision making procedures, performance measures, and adaptive mechanisms, they really need to manage the indicated digital and AI-driven enhancement efforts.

As a way to promote continuous learning and improve collaboration within the business, periodic reviews and the implementation of performance measurement tools can also be used to track progress. Managers in important positions can utilize the study’s findings to compare results and pinpoint areas that require improvement. Numerous procedures must be put in place in order to do this, which calls for the support of top management and a well-defined strategy for responsible AI integration across the entire organization. As many businesses are still in the early stages of implementing AI technologies, it is crucial to do so responsibly in order to benefit from the creation of new capabilities that can improve performance. Although additional implementation concerns need to be built into the overall design due to the complexity and cost of AI systems, the advantages can be swiftly appreciated on management and financial levels.

Last but not least, given the complexity of AI applications, the majority of businesses do not yet have a department dedicated to the development of AI. It is obvious that management needs to devote more time and expense to developing AI capabilities. Since AI is created from idea to implementation, new capabilities will come from the AI team itself. This implies that competent AI development teams have the chance and authority to alter outcomes in a way that is advantageous and positive by putting AI-driven projects into practice that follow a responsible AI framework. Managers must plan ahead and make investments before their rivals if they want to maintain their competitiveness and drive future business value. On the other hand, getting on top of the competition requires time. It demands a methodical strategy in which all managerial efforts are confined inside a framework that unambiguously directs the essential measures to attain representative AI practices.

Regarding the article’s limits, even though we searched for numerous permutations of the linked terms, there may still be publications mentioning AI, strategy, digital transformation, and business value that do not use the term, or variations of it, in their title or abstract. Additionally, by limiting our search to business-related issues, we were able to dismiss more technical publications. Furthermore, we excluded studies that advanced the state of the art in other languages and solely examined articles written in English. It is worth mentioning that the industrial applications of AI, such as those in smart cities, the health industry, manufacturing, etc., need a lot more attention and a unique survey comparing the requirements, difficulties, and solutions among the various industries.

To summarize, the focus of our research is on how digital transformation and AI can work together to create enhanced business value outcomes from a strategic point of view. Future research could carefully evaluate each model substitution and assess the aforementioned conceptual model both theoretically and experimentally. We examined the most important aspects of AI capabilities, so it might be interesting for future research to group the connections and value streams that are produced as a result of various use cases and applications for better strategic implementation across diverse circumstances. This digital age is changing at a rapid pace and so must organizations if they do not want to be left behind in a deep technological void.

Integrating AI solutions into business strategies can bring significant benefits to the company, such as increased efficiency, improved decision-making, and new revenue streams. However, successfully implementing AI requires a well-thought-out plan and a clear understanding of the technology and its capabilities.

First and foremost, it is crucial to conduct a thorough analysis of the business needs and goals to determine where AI can be most effectively utilized. This will help to identify specific areas where AI can bring the greatest value and enable the company to set clear and measurable objectives for implementation. Once the areas have been identified, it is important to develop a clear understanding of the available AI technologies and their capabilities and match them to the identified business needs.

To ensure that the AI solution being implemented is aligned with the overall business strategy, it is important to create a cross-functional team with representatives from various departments such as IT, operations, and marketing. This team should be responsible for defining the scope of the project, setting the budget, and monitoring progress. Additionally, proper data management and governance infrastructure are crucial for the success of an AI project. Without accurate, reliable, and compliant data, AI systems will not be able to function effectively. Therefore, it is important to invest in data management and governance infrastructure to ensure that the data being used to train and operate AI systems are accurate, reliable, and compliant with relevant regulations.

It is also important to measure the performance and impact of the AI solution on the business, establish clear metrics that are aligned with the objectives of the project, continuously monitor and evaluate the performance of the AI solution, and make adjustments as necessary. To foster a culture of experimentation and innovation, organizations must encourage employees to test and suggest new AI-based ideas and solutions. This will help to identify new opportunities and improve the overall effectiveness of the AI solution. Additionally, it is important to stay informed about the latest developments in AI and related technologies, adapt the strategy accordingly, and plan for potential ethical and legal considerations, such as data privacy and bias, to ensure compliance with laws and regulations and maintain public trust, and consider partnering with AI experts or vendors to gain access to specialized skills and resources. This will help to ensure that the implementation is performed correctly and that the solution is tailored to the specific needs of the company. By following these recommendations, the company will be well on its way to successfully integrating AI solutions into its business strategies and reaping the benefits that AI has to offer.

# 5. Conclusions

AI has been hailed as a revolutionary technology that has the potential to change the way businesses operate. This study delves into the specific ways in which AI can be integrated with business and IT strategies in order to help organizations navigate the digital landscape and achieve their goals. The research finds that the integration of AI capabilities with business/IT strategy is a key enabler of digital transformation alignment and that the synergistic ambidexterity effect of innovative and routine AI deployment outweighs the solo benefit.

One of the key takeaways from this study is that AI is not just a tool, but a force that can shape the very nature of an organization. As businesses seek to harness the power of AI, they must be mindful of the ways in which this technology can be used to create new opportunities and unlock new forms of value. This requires not only a deep understanding of the technology itself but also a willingness to question established norms and explore uncharted territories.

In this sense, the integration of AI with business and IT strategies can be seen as a form of alchemy, in which organizations are able to transmute the raw materials of data and technology into new forms of value and competitiveness. This process requires a deep understanding of the underlying principles of AI, as well as a willingness to experiment and take risks.

Ultimately, this study highlights the importance of embracing the potential of AI in order to thrive in the digital age. As businesses seek to stay ahead of the curve and adapt to the rapidly changing landscape, they must be willing to question the status quo and explore the uncharted territories that AI has opened up. In doing so, they can unlock new forms of value and gain a competitive edge that is difficult to replicate.

Author Contributions: Conceptualization, N.-A.P.; methodology, N.-A.P. and F.K.; investigation, N.-A.P.; data curation, F.K.; writing—original draft preparation, N.-A.P. and F.K.; writing—review and editing, N.-A.P. and F.K.; visualization, N.-A.P.; supervision, F.K. All authors have read and agreed to the published version of the manuscript.

Funding: This research received no external funding.

Data Availability Statement: This study did not report any data.

Conflicts of Interest: The authors declare no conflict of interest.

# Appendix A

Table A1. Concept matrix table. Source: Own elaboration.   

<html><body><table><tr><td colspan="10">Concepts</td></tr><tr><td colspan="10">The integration of AI and Business/IT Artificial Intelligence Capabilities in Organizations towards Digital Transformation Alignment for Enhanced Business Value Outcomes</td></tr><tr><td colspan="10"></td></tr><tr><td>No.</td><td>Authors</td><td>Year</td><td> Ambidexerity</td><td>CAICpaiation</td><td> AI Resores</td><td>AI Governance</td><td>Feabity</td><td>Ts</td><td></td></tr><tr><td></td><td>Kitsios and Kamariotou [1] Zhou and Li [2]</td><td>2021</td><td></td><td></td><td>X</td><td></td><td>X</td><td>X</td><td>X</td></tr><tr><td>Kar et al. [3]</td><td></td><td>2010 2021</td><td></td><td>X</td><td>X X</td><td>+</td><td>X</td><td>X</td><td>X</td></tr><tr><td></td><td> van de Wetering et al. [4]</td><td>2021</td><td></td><td>X</td><td>X</td><td></td><td>X</td><td>X</td><td>X X</td></tr><tr><td></td><td>Ransbothatm et al. [5]</td><td>2019</td><td></td><td>X</td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>X</td></tr><tr><td>Trunk et al. [7]</td><td>Brynjolfsson and Mcafee [6]</td><td>2017</td><td></td><td>X</td><td>X</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td></td><td>2020</td><td></td><td>+</td><td>十</td><td>X</td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Brock and von Wangenheim [8]</td><td>2019</td><td>X</td><td>+</td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Al Surmi et al. [9]</td><td>2022</td><td>X</td><td>X</td><td></td><td>+</td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Chowdhury et al. [10]</td><td>2022</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td>Makowski and Kajikawa [11]</td><td>2021</td><td></td><td>+</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td>Jarrahi [12]</td><td></td><td>2018</td><td></td><td></td><td></td><td>X</td><td></td><td>X</td><td></td></tr><tr><td>van de Wetering [13]</td><td></td><td>2022</td><td>X</td><td>X</td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Mikalef and Gupta [14]</td><td></td><td>2021</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td>Canhoto and Clear [15]</td><td></td><td>2020</td><td></td><td></td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Wamba-Taguimdje et al. [16]</td><td></td><td>2020</td><td>X</td><td></td><td></td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Haefner et al. [17]</td><td></td><td>2021</td><td>X</td><td></td><td>X</td><td></td><td></td><td></td><td></td></tr><tr><td>Dwivedi et al. [18]</td><td></td><td>2021</td><td></td><td></td><td></td><td>X</td><td></td><td>X</td><td></td></tr><tr><td>Truong and Papagiannidis [19]</td><td></td><td>2022</td><td>X</td><td></td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td>Fuller et al. [20]</td><td></td><td>2022</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td>van de Wetering [21]</td><td></td><td>2022</td><td>X</td><td></td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Majhi et al. [22]</td><td>2021</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td> van de Wetering [23]</td><td>2021</td><td>X</td><td></td><td></td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Benbya et al. [24]</td><td>2021</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Berente et al. [25]</td><td>2021</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td></td><td>2021</td><td>X</td><td>十</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td></tr><tr><td>Borges [26]</td><td>Keding [27]</td><td>2021</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td></tr><tr><td></td><td>Tschang and Almirall [28]</td><td>2021</td><td></td><td></td><td>X</td><td></td><td>X</td><td></td><td>X</td></tr><tr><td></td><td></td><td>2018</td><td>十</td><td></td><td>X</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Davenport [29]</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>X</td></tr></table></body></html>

Table A2. Concept matrix table. Source: Own elaboration.   

<html><body><table><tr><td></td><td colspan="9">Concepts</td></tr><tr><td></td><td colspan="6">Artificial Intelligence Capabilities in Organizations</td><td colspan="3">The integration of AI and Business/IT towards Digital Transformation Alignment for Enhanced Business Value Outcomes</td></tr><tr><td>No.</td><td>Authors</td><td>Year</td><td>Ambidexterity</td><td> CAI Cpaiation</td><td> AI Restrien</td><td>AI Governance</td><td>Flexibity</td><td></td><td></td></tr><tr><td></td><td>Chatterjee et al. [30]</td><td>2020</td><td></td><td></td><td>X</td><td>X</td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Mishra and Pani [31] Fadler and Legner [32]</td><td>2021 2021</td><td>X</td><td>X</td><td>X X</td><td>X X</td><td>X</td><td>X</td><td>X</td></tr><tr><td></td><td>Davenport and Ronanki [33]</td><td>2018</td><td>X</td><td>X X</td><td>X</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Barnea [34]</td><td>2020</td><td></td><td></td><td></td><td>X</td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Amershi et al. [35]</td><td>2019</td><td></td><td></td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Frank et al. [36]</td><td>2019</td><td>X</td><td></td><td>X</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td></td><td></td><td>X</td><td>X</td><td>X</td><td></td><td>+</td><td></td><td></td></tr><tr><td></td><td>Butcherand Bt al e719]</td><td>2022</td><td></td><td>X</td><td>X</td><td>xx</td><td></td><td>Xx</td><td></td></tr><tr><td></td><td></td><td>2021</td><td>X</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Yigit and Kanbach [42]</td><td></td><td></td><td>X</td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Bag et al. [43]</td><td>2021</td><td></td><td>X</td><td>X</td><td>X</td><td>X</td><td></td><td></td></tr><tr><td></td><td>Collins et al. [44]</td><td>2021</td><td></td><td>X</td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Yu and Moon [45]</td><td>2021 2022</td><td></td><td></td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Awwad et al. [48]</td><td></td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Cebeci [50]</td><td>2021</td><td></td><td></td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Enholm et al. [51]</td><td>2021</td><td></td><td></td><td></td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Zuiderwijk et al. [52]</td><td>2021</td><td></td><td></td><td>X</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Grover et al. [53]</td><td>2022</td><td></td><td>X</td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td>Caner and Bhatti [54]</td><td>2020</td><td></td><td></td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Smacchia and Za [55]</td><td>2022</td><td>X</td><td></td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Di Vaio et al. [56]</td><td>2020</td><td>X</td><td></td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Dhamija and Bag [57]</td><td>2020</td><td></td><td></td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Haenlein and Kaplan [58]</td><td>2019</td><td>X</td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Cark [59]</td><td>2022</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Shrestha et al. [60]</td><td>2019</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Shrestha et al. [61]</td><td>2021</td><td>X</td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>2018</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>von Krogh [62]</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Agrawal et al. [63]</td><td>2019</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Whittington [65]</td><td>2014</td><td>X</td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>KLigetal 66</td><td>2021</td><td>X</td><td></td><td></td><td></td><td></td><td></td><td>Xx</td></tr><tr><td></td><td>Carter et al. [69]</td><td>2020</td><td>X</td><td></td><td></td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Sestino and Mauro [71]</td><td>2022</td><td>X</td><td></td><td></td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td></td><td>2019</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td></tr><tr><td></td><td>Warner and Wäger [72] Huang and Rust [73]</td><td>2021</td><td>X</td><td>X</td><td></td><td></td><td>X</td><td>X</td><td>X</td></tr></table></body></html>

Table A3. Concept matrix table. Source: Own elaboration.   

<html><body><table><tr><td></td><td></td><td></td><td colspan="7">Concepts</td></tr><tr><td></td><td></td><td colspan="4">Artificial Intelligence Capabilities in Organizations</td><td colspan="4">The integration of AI and Business/IT towards Digital Transformation Alignment for Enhanced Business Value Outcomes</td></tr><tr><td>No.</td><td>Authors</td><td>Year</td><td>Ambidexterity</td><td>CAL Cpaliration</td><td> AI Restrurices</td><td>AI Governance</td><td>Fexbity</td><td></td><td></td></tr><tr><td></td><td> Wamba-Taguimdje et al. [74]</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Papachroni et al. [75]</td><td>2020 2015</td><td>X X</td><td>X X</td><td>X X</td><td></td><td>X</td><td>X</td><td>X X</td></tr><tr><td></td><td>van de Wetering and Versendaal [76]</td><td>2021</td><td>X</td><td></td><td>X</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Diaz-Fernandez et al. [77]</td><td>2017</td><td>X</td><td>X</td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Paschen et al. [79]</td><td>2020</td><td></td><td>X</td><td></td><td></td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Phan et al. [80]</td><td>2017</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Gabruio and Lin [81]</td><td>2019</td><td></td><td>X</td><td>X</td><td>X</td><td></td><td></td><td>X</td></tr><tr><td></td><td>Hengstler [82]</td><td>2016</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Barro and Davenport [83]</td><td>2019</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Desouza et al. [84]</td><td>2020</td><td>X</td><td></td><td>X</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>2020</td><td></td><td>X</td><td></td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Reis et al. [85]</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Alsheibani et al. [86]</td><td>2020</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Sjodin et al. [87]</td><td>2021</td><td>X</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Weber et al. [88]</td><td>2022</td><td></td><td></td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Aydiner et al. [90]</td><td>2019</td><td></td><td></td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Bamel et al. [95]</td><td>2018</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Mikalef et al. [98]</td><td>2019</td><td>X</td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Uren et al.[101]</td><td>2023</td><td>X</td><td>X</td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Kurniawan et al. [102]</td><td>2020</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Carnes et al. [103]</td><td>2017</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Mikalef et al. [104]</td><td>2019</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Ho et al. [106]</td><td>2022</td><td></td><td></td><td></td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td>Fosso Wamba [108]</td><td>2022</td><td></td><td></td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Lee et al. [109]</td><td>2022</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>van de Wetering et al. [111]</td><td>2022</td><td>X</td><td>X</td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Papagiannidis et al. [112]</td><td></td><td></td><td></td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Fountaine et al. [113]</td><td>2021</td><td></td><td></td><td>X</td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>2019</td><td></td><td>X</td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Lichtenthaler [114]</td><td>2019</td><td></td><td></td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Papagiannidis etal.[115]</td><td>2022</td><td></td><td>X</td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td>de Laat [116]</td><td>2021</td><td>X</td><td>X</td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td>Kruhse-Lehtonen and Hofmann [118]</td><td></td><td>2020</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Schneider et al. [119]</td><td>2022</td><td>X</td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Chen et al. [120]</td><td>2022</td><td></td><td></td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td></td><td></td><td></td><td>X</td><td></td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td>Smit et al. [121] Alsheibani et al. [122]</td><td>2020 2019</td><td></td><td>X</td><td>X</td><td></td><td></td><td></td><td></td></tr></table></body></html>

Table A4. Concept matrix table. Source: Own elaboration.   

<html><body><table><tr><td colspan="10">Concepts The integration of AI and Business/IT</td></tr><tr><td colspan="10">Artificial Intelligence Capabilities in Organizations towards Digital Transformation Alignment for Enhanced Business Value Outcomes</td></tr><tr><td>No.</td><td>Authors</td><td>Year</td><td> Ambidexterity</td><td>CAI Capaliaten</td><td> A Restatien</td><td>AI Governance</td><td></td><td></td><td></td></tr><tr><td></td><td> Abraham etal123]</td><td>2019</td><td></td><td>X</td><td>X</td><td>xx</td><td></td><td>xx</td><td>xx</td></tr><tr><td></td><td>Scherer [125] Clarke[126]</td><td>2015 2019</td><td></td><td>X</td><td></td><td>X</td><td></td><td>X</td><td>X</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>X</td><td>X</td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Kaplan and Haenlein [129]</td><td>2019</td><td></td><td>+</td><td></td><td>X</td><td>X</td><td></td><td></td></tr><tr><td></td><td>Minkkien et al. [131]</td><td>2021</td><td></td><td></td><td>X</td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>Ledro et al. [132]</td><td>2022</td><td></td><td></td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td>Lwakatare et al. [133]</td><td>2019</td><td></td><td></td><td></td><td>X</td><td></td><td>X</td><td>X</td></tr><tr><td></td><td>Wang et al. [134]</td><td>2022</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td><td></td><td></td></tr><tr><td></td><td></td><td>2019</td><td></td><td>X</td><td></td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Dignum[135]</td><td></td><td></td><td>X</td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Brozovic [136]</td><td>2018</td><td></td><td></td><td></td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Van de Wetering et al. [138]</td><td>2019</td><td>X</td><td></td><td>X</td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Haarhaus and Liening [140]</td><td>2020</td><td></td><td></td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Combe et al. [144]</td><td>2012</td><td></td><td></td><td></td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Radomska et ai. [145]</td><td></td><td>2015</td><td>X</td><td></td><td></td><td></td><td>X</td><td></td><td></td></tr><tr><td>Kortmann et al. [147]</td><td></td><td>2014</td><td></td><td>X</td><td>X</td><td></td><td>X</td><td>X</td><td></td></tr><tr><td></td><td>Van de Wetering and Mikalef [148]</td><td>2017</td><td></td><td>X</td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td>Matalamaki,MJand JoensuuSalo</td><td></td><td>2022</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td>Yi et al. [150]</td><td></td><td>2017</td><td>X</td><td></td><td>X</td><td></td><td>X</td><td>十</td><td></td></tr><tr><td>Chan and Zhong [151]</td><td></td><td>2018</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr><tr><td>Avramov et al. [152]</td><td></td><td>2022</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td>Kou et al. [153]</td><td></td><td>2019</td><td>X</td><td></td><td></td><td></td><td>X</td><td>X</td><td></td></tr><tr><td>Lee et al.[155]</td><td></td><td>2018</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td>Suominen et al. [156]</td><td></td><td>2017</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Khan et al. [157]</td><td>2022</td><td>X</td><td>X</td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Mishra et al. [159]</td><td>2022</td><td></td><td>X</td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Gomez-Uribe [162]</td><td>2016</td><td></td><td></td><td></td><td></td><td></td><td>X</td><td></td></tr><tr><td></td><td>Drydakis [163]</td><td>2022</td><td>+</td><td></td><td>X</td><td>X</td><td></td><td>X</td><td></td></tr><tr><td></td><td></td><td>2017</td><td></td><td></td><td>X</td><td></td><td></td><td></td><td></td></tr><tr><td>Brynjolfsson and Mitchell [164]</td><td></td><td>2021</td><td></td><td></td><td>X</td><td>X</td><td>X</td><td>X</td><td></td></tr><tr><td>Moloi and Marwala [165]</td><td>Benitez et al. [166]</td><td>2018</td><td>X</td><td></td><td></td><td></td><td>X</td><td></td><td></td></tr><tr><td></td><td>Coombs et al. [168]</td><td>2020</td><td></td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td></tr><tr><td></td><td>Menon et al. [169]</td><td>2018</td><td></td><td></td><td></td><td></td><td>X</td><td>X</td><td>X</td></tr></table></body></html>

Table A5. Concept matrix table. Source: Own elaboration.   

<html><body><table><tr><td colspan="8">Concepts</td></tr><tr><td></td><td>Artificial Intelligence Capabilities in Organizations</td><td colspan="4"></td><td colspan="3">The integration of AI and Business/IT towards Digital Transformation Alignment for Enhanced Business Value Outcomes</td></tr><tr><td>No. Authors</td><td></td><td>Year Ambidexterity</td><td>CAICapaliation</td><td> AI Restarien</td><td>AI Governance</td><td></td><td></td><td></td></tr><tr><td>Trocin et al. [170]</td><td>2021</td><td>X</td><td>X</td><td>X</td><td></td><td></td><td>X</td><td>X</td></tr><tr><td>Chalmers et al. [171]</td><td>2021</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td><td>X</td></tr><tr><td>Lui et al. [174]</td><td>2022</td><td></td><td>X</td><td></td><td></td><td></td><td></td><td>X</td></tr><tr><td></td><td>2020</td><td>X</td><td>xx</td><td>xx</td><td></td><td>X</td><td>xx</td><td>xx</td></tr><tr><td></td><td>2021</td><td>X</td><td>X</td><td>X</td><td>X</td><td></td><td></td><td></td></tr><tr><td>Miroshnychenko et al. [179] Li et al. [180]</td><td>2022</td><td></td><td>X</td><td>X</td><td></td><td>X X</td><td>X X</td><td>X X</td></tr></table></body></html>

Legend: The symbol $' _ { \mathbf { X } } \prime$ is used to denote the specific concepts referred to in each citation.

# ReferencesSustainabilit

1. Z Kitsios, F.; Kamariotou, M. Artificial Intelligence and Business Strategy towards Digital Transformation: A Research Agenda.u, K.Z.; Li, C.B. How Strategic Orientations Influence the Building of Dynamic Capability in Emerging Economies. J. Bus. Sustainability 2021, 13, 2025. [CrossRef] 2010, 63, 224–231. https://doi.org/10.101   
2. K Zhou, K.Z.; Li, C.B. How Strategic Orientations Influence the Building of Dynamic Capability in Emerging Economies. J. Bus. Res., S.; Kar, A.K.; Gupta, M.P. Modeling Drivers and Barriers of Artificial Intelligence Adoption: Insights from a Strategic Man  
2010, 63, 224–231. [CrossRef]ment Perspective. Intell. Syst.   
3. v Kar, S.; Kar, A.K.; Gupta, M.P. Modeling Drivers and Barriers of Artificial Intelligence Adoption: Insights from a Strategic de Wetering, R.; Hendrickx, T.; Brinkkemper, S.; Kurnia, S. The Impact of EA-Driven Dynamic Capabilities, Innovativeness, Management Perspective. Intell. Syst. Account. Financ. Manag. 2021, 28, 217–238. [CrossRef] Structure on Organizational Benefits: A Variance and FsQCA Perspective. S   
4. h van de Wetering, R.; Hendrickx, T.; Brinkkemper, S.; Kurnia, S. The Impact of EA-Driven Dynamic Capabilities, Innovativeness,s://doi.org/10.3390/su13105414. and Structure on Organizational Benefits: A Variance and FsQCA Perspective. Sustainability 2021, 13, 5414. [CrossRef]sbotham, S.; Khodabandeh, S.; Fehling, R.; Lafountain, B.; Kiron, D. Winning with Ai. In Technical Report; MIT Sloan M   
5. a Ransbotham, S.; Khodabandeh, S.; Fehling, R.; Lafountain, B.; Kiron, D. Winning with Ai. In Technical Report; MIT Sloanment Review and Boston Consulting Group: Boston, MA, USA, 2019. Management Review and Boston Consulting Group: Boston, MA, USA, 2019.njolfsson, E.; Mcafee, A. The business of artificial intelligence. Harv. Bus. Rev. 2   
6. T Brynjolfsson, E.; Mcafee, A. The business of artificial intelligence. Harv. Bus. Rev. 2017, 7, 3–11.nk, A.; Birkel, H.; Hartmann, E. On the Current State of Combining Human and Artificial Intel   
7.z Trunk, A.; Birkel, H.; Hartmann, E. On the Current State of Combining Human and Artificial Intelligence for Strategic Organiza-onal Decision Making. Bus. Res. 2020, 13, 875–919. https://doi.org/10.1007/s40685-020-00133-x. tional Decision Making. Bus. Res. 2020, 13, 875–919. [CrossRef]k, J.K.-U.; von Wangenheim, F. Demystifying AI: What Digit   
8. A Brock, J.K.-U.; von Wangenheim, F. Demystifying AI: What Digital Transformation Leaders Can Teach You about Realisticficial Intelligence. Calif. Manag. Rev. 2019, 61, 110–134. https://doi.org/10.1177/1536504219865226. Artificial Intelligence. Calif. Manag. Rev. 2019, 61, 110–134. [CrossRef]urmi, A.; Bashiri, M.; Koliousis, I. AI Based Decision Making: Combin   
9. In Al-Surmi, A.; Bashiri, M.; Koliousis, I. AI Based Decision Making: Combining Strategies to Improve Operational Performance. J. Prod. Res. 2022, 60, 4464–4486. https://doi.org/10.1080/00207543.2021.1966540. Int. J. Prod. Res. 2022, 60, 4464–4486. [CrossRef]wdhury, S.; Dey, P.; Joel-Edgar, S.; Bhattacharya   
10. of Chowdhury, S.; Dey, P.; Joel-Edgar, S.; Bhattacharya, S.; Rodriguez-Espindola, O.; Abadie, A.; Truong, L. Unlocking the Valuertificial Intelligence in Human Resource Management through AI Capability Framework. Hum. Resour. Manag. Rev. 2022, of Artificial Intelligence in Human Resource Management through AI Capability Framework. Hum. Resour. Manag. Rev. 2022,00899. https://doi.org/10.1016/j.hrmr.2022.100899.   
33, 100899. [CrossRef]owski, P.T.; Kajikawa,   
11. Te Makowski, P.T.; Kajikawa, Y. Automation-Driven Innovation Management? Toward Innovation-Automation-Strategy Cycle.hnol. Forecast. Soc. Chang. 2021, 168, 120723. https://doi.org/10.1016/j.techfore.2021.120723. Technol. Forecast. Soc. Chang. 2021, 168, 120723. [CrossRef]ahi, M.H. Artificial Intelligence and the Future of Work:   
12. Ho Jarrahi, M.H. Artificial Intelligence and the Future of Work: Human-AI Symbiosis in Organizational Decision Making. Bus. Horiz.iz. 2018, 61, 577–586. https://doi.org/10.1016/j.bushor.2018.03.007.   
2018, 61, 577–586. [CrossRef]de Wetering, R.; Milakef, P.;   
13. Th van de Wetering, R.; Milakef, P.; Dennehy, D. Artificial Intelligence Ambidexterity, Adaptive Transformation Capability, andir Impact on Performance Under Tumultuous Times. In The Role of Digital Technologies in Shaping the Post-Pandemic World; Their Impact on Performance Under Tumultuous Times. In The Role of Digital Technologies in Shaping the Post-Pandemic World;agiannidis, S., Alamanos, E., Gupta, S., Dwivedi, Y.K., Mäntymäki, M., Pappas, I.O., Eds.; Lecture Notes in Computer SciPapagiannidis, S., Alamanos, E., Gupta, S., Dwivedi, Y.K., Mäntymäki, M., Pappas, I.O., Eds.; Lecture Notes in Computer Science;e; Springer International Publishing: Cham, Switzerland, 2022; Volume 13454, pp. 25–37; ISBN 978-3-031-15341-9. Springer International Publishing: Cham, Switzerland, 2022; Volume 13454, pp. 25–37, ISBN 978-3-031-15341-9.alef, P.; Gupta, M. Artificial Intelligence Capability: Conceptualization, Measurement Calibration, and Empiric   
14. Its Mikalef, P.; Gupta, M. Artificial Intelligence Capability: Conceptualization, Measurement Calibration, and Empirical Study on ItsImpact on Organizational Creativity and Firm Performance. Inf. Manag. 2021, 58, 103434. Impact on Organizational Creativity and Firm Performance. Inf. Manag. 2021, 58, 103434. [CrossRef]s://doi.org/10.1016/j.im.2021.103434.   
15. Ca Canhoto, A.I.; Clear, F. Artificial Intelligence and Machine Learning as Business Tools: A Framework for Diagnosing Valuehoto, A.I.; Clear, F. Artificial Intelligence and Machine Learning as Business Tools: A Framework for Diagnosing Value Destruction Potential. Bus. Horiz. 2020, 63, 183–193. [CrossRef]ruction Potential. Bus. Horiz. 2020, 63, 183–193. https://doi.org/1   
16. W Wamba-Taguimdje, S.-L.; Fosso Wamba, S.; Kala Kamdjoug, J.R.; Tchatchouang Wanko, C.E. Influence of Artificial Intelligencemba-Taguimdje, S.-L.; Fosso Wamba, S.; Kala Kamdjoug, J.R.; Tchatchouang Wanko, C.E. Influence of Artificial Intelligence (AI) on Firm Performance: The Business Value of AI-Based Transformation Projects. Bus. Process Manag. J. 2020, 26, 1893–1924. on Firm Performance: The Business Value of AI-Based Transformation Projects. Bus. Process Manag. J. 2020, 26, 1893–1924. [CrossRef]s://doi.org/   
17. Ha Haefner, N.; Wincent, J.; Parida, V.; Gassmann, O. Artificial Intelligence and Innovation Management: A Review, Framework, andfner, N.; Wincent, J.; Parida, V.; Gassmann, O. Artificial Intelligence and Innovation Management: A Review, Framework, Research Agenda Research Agenda✰. Technol. Forecast. Soc. Chang. 2021, 162, 120392. https://doi.. Technol. Forecast. Soc. Chang. 2021, 162, 120392. [CrossRef] D18. ivedi, Y.K.; Hughes, L.; Ismagilova, E.; Aarts, G.; Coombs, C.; Crick, T.; Duan, Y.; Dwivedi, R.; Edwards, J.; Eirug, A.; et al. Dwivedi, Y.K.; Hughes, L.; Ismagilova, E.; Aarts, G.; Coombs, C.; Crick, T.; Duan, Y.; Dwivedi, R.; Edwards, J.; Eirug, A.; et al. ficial Intelligence (AI): Multidisciplinary Perspectives on Emerging Challenges, Opportunities, and Agenda for Research, Artificial Intelligence (AI): Multidisciplinary Perspectives on Emerging Challenges, Opportunities, and Agenda for Research, tice and Policy. Int. J. Inf. Manag. 2021, 57, 101994. https://doi.org/Practice and Policy. Int. J. Inf. Manag. 2021, 57, 101994. [CrossRef] Tr19. ong, Y.; Papagiannidis, S. Artificial Intelligence as an Enabler for Innovation: A Review and Future Research Agenda. Tech-Truong, Y.; Papagiannidis, S. Artificial Intelligence as an Enabler for Innovation: A Review and Future Research Agenda. Forecast. Soc. Chang. 2022, 183, 121852. https://doi.org/10.1Technol. Forecast. Soc. Chang. 2022, 183, 121852. [CrossRef] Fü20. er, J.; Hutter, K.; Wahl, J.; Bilgram, V.; Tekic, Z. How AI Revolutionizes Innovation Management–Perceptions and Imple-Füller, J.; Hutter, K.; Wahl, J.; Bilgram, V.; Tekic, Z. How AI Revolutionizes Innovation Management–Perceptions and Implementatation Preferences of AI-Based Innovators. Technol. Forecast. Soc. Chang. 2022, 178, 121598. https:/tion Preferences of AI-Based Innovators. Technol. Forecast. Soc. Chang. 2022, 178, 121598. [CrossRef] fo21. .2022.121598. Wetering, R.V.D. The impact of artificial intelligence ambidexterity and strategic flexibility on operational ambidexterity. In ering, R.v. d., 2022. The impact of artificial intelligence ambidexterity and strategic flexibility on operational ambidexterity. Proceedings of the PACIS 2022 Proceedings, Taipei, Sydney, 5–9 July 2022; p. 153. Available online: https://aisel.aisnet.org/ PACIS 2022 Proceedings, 153. https://ai sel.aispacis2022/153 (accessed on 1 January 2023). M22. hi, S.G.; Mukherjee, A.; Anand, A. Business Value of Cognitive Analytics Technology: A Dynamic Capabilities Perspective. Majhi, S.G.; Mukherjee, A.; Anand, A. Business Value of Cognitive Analytics Technology: A Dynamic Capabilities Perspective. E J. Inf. Knowl. Manag. Syst. 2021, 1-19. https://doi.org/1VINE J. Inf. Knowl. Manag. Syst. 2021, 1–19. [CrossRef] va23. de Wetering, R. Achieving Digital-Driven Patient Agility in the Era of Big Data. In Responsible AI and Analytics for an Ethical van de Wetering, R. Achieving Digital-Driven Patient Agility in the Era of Big Data. In Responsible AI and Analytics for an Ethical and Inclusive Digitized Society; Dennehy, D., Griva, A., Pouloudi, N., Dwivedi, Y.K., Pappas, I., Mäntymäki, M., Eds.; Lecture Inclusive Digitized Society; Dennehy, D., Griva, A., Pouloudi, N., Dwivedi, Y.K., Pappas, I., Mäntymäki, M., Eds.; Lecture Notes in es in Computer Science; Springer International Publishing: Cham, Switzerland, 2021; Volume 12896, pp. 82–93; ISBN 978-3-Computer Science; Springer International Publishing: Cham, Switzerland, 2021; Volume 12896, pp. 82–93, ISBN 978-3-030-85446-1.   
0324. 85446-1. Benbya, H.; Pachidi, S.; Jarvenpaa, S. Special Issue Editorial: Artificial Intelligence in Organizations: Implications for Information bya, H.; Deakin University, Melbourne, Australia; Pachidi, S.; CamSystems Research. J. Assoc. Inf. Syst. 2021, 22, 281–303. [CrossRef] Un25. ted Kingdom; Jarvenpaa, S.L.; McCombs School of Business, University of Texas at Austin, USA. SpeciaBerente, N.; Gu, B.; Recker, J.; Santhanam, R. Managing artificial intelligence. MIS Q. 2021, 45, 1433–1450.   
26. Borges, A.F.S.; Laurindo, F.J.B.; Spínola, M.M.; Gonçalves, R.F.; Mattos, C.A. The Strategic Use of Artificial Intelligence in the Digital Era: Systematic Literature Review and Future Research Directions. Int. J. Inf. Manag. 2021, 57, 102225. [CrossRef]   
27. Keding, C. Understanding the Interplay of Artificial Intelligence and Strategic Management: Four Decades of Research in Review. Manag. Rev. Q. 2021, 71, 91–134. [CrossRef]   
28. Tschang, F.T.; Almirall, E. Artificial Intelligence as Augmenting Automation: Implications for Employment. Acad. Manag. Perspect. 2021, 35, 642–659. [CrossRef]   
29. Davenport, T.H. From Analytics to Artificial Intelligence. J. Bus. Anal. 2018, 1, 73–80. [CrossRef]   
30. Chatterjee, S.; Ghosh, S.K.; Chaudhuri, R. Knowledge Management in Improving Business Process: An Interpretative Framework for Successful Implementation of AI–CRM–KM System in Organizations. Bus. Process Manag. J. 2020, 26, 1261–1281. [CrossRef]   
31. Mishra, A.N.; Pani, A.K. Business Value Appropriation Roadmap for Artificial Intelligence. VINE J. Inf. Knowl. Manag. Syst. 2021, 51, 353–368. [CrossRef]   
32. Fadler, M.; Legner, C. Toward Big Data and Analytics Governance: Redefining Structural Governance Mechanisms. In Proceedings of the 54th Hawaii International Conference on System Sciences, Virtual, 5 January 2021.   
33. Davenport, T.H.; Ronanki, R. Artificial intelligence for the real world. Harv. Bus. Rev. 2018, 96, 108–116.   
34. Barnea, A. How Will AI Change Intelligence and Decision-Making? J. Intell. Stud. Bus. 2020, 1. [CrossRef]   
35. Amershi, S.; Begel, A.; Bird, C.; DeLine, R.; Gall, H.; Kamar, E.; Nagappan, N.; Nushi, B.; Zimmermann, T. Software Engineering for Machine Learning: A Case Study. In Proceedings of the 2019 IEEE/ACM 41st International Conference on Software Engineering: Software Engineering in Practice (ICSE-SEIP), Montreal, QC, Canada, 25–31 May 2019; pp. 291–300.   
36. Frank, M.R.; Autor, D.; Bessen, J.E.; Brynjolfsson, E.; Cebrian, M.; Deming, D.J.; Feldman, M.; Groh, M.; Lobo, J.; Moro, E.; et al. Toward Understanding the Impact of Artificial Intelligence on Labor. Proc. Natl. Acad. Sci. USA 2019, 116, 6531–6539. [CrossRef]   
37. Krakowski, S.; Luger, J.; Raisch, S. Artificial Intelligence and the Changing Sources of Competitive Advantage. Strateg. Manag. J. 2022, smj.3387. [CrossRef]   
38. Raisch, S.; Birkinshaw, J.; Probst, G.; Tushman, M.L. Organizational Ambidexterity: Balancing Exploitation and Exploration for Sustained Performance. Organ. Sci. 2009, 20, 685–695. [CrossRef]   
39. Butcher, J.; Beridze, I. What Is the State of Artificial Intelligence Governance Globally? RUSI J. 2019, 164, 88–96. [CrossRef]   
40. Bharadwaj, A.S. A Resource-Based Perspective on Information Technology Capability and Firm Performance: An Empirical Investigation. MIS Q. 2000, 24, 169. [CrossRef]   
41. Kohli, R.; Grover, V. Business Value of IT: An Essay on Expanding Research Directions to Keep up with the Times. J. Assoc. Inf. Syst. 2008, 9, 23–39. [CrossRef]   
42. Yigit, A.; Kanbach, D. The importance of Artificial Intelligence in strategic Management: A literature Review. Int. J. Strateg. Manag. 2021, 21, 5–40. [CrossRef]   
43. Bag, S.; Gupta, S.; Kumar, A.; Sivarajah, U. An Integrated Artificial Intelligence Framework for Knowledge Creation and B2B Marketing Rational Decision Making for Improving Firm Performance. Ind. Mark. Manag. 2021, 92, 178–189. [CrossRef]   
44. Collins, C.; Dennehy, D.; Conboy, K.; Mikalef, P. Artificial Intelligence in Information Systems Research: A Systematic Literature Review and Research Agenda. Int. J. Inf. Manag. 2021, 60, 102383. [CrossRef]   
45. Yu, J.; Moon, T. Impact of Digital Strategic Orientation on Organizational Performance through Digital Competence. Sustainability 2021, 13, 9766. [CrossRef]   
46. Teece, D.J.; Pisano, G.; Shuen, A. Dynamic Capabilities and Strategic Management. Strateg. Manag. J. 1997, 18, 509–533. [CrossRef]   
47. Eshima, Y.; Anderson, B.S. Firm Growth, Adaptive Capability, and Entrepreneurial Orientation. Strateg. Manag. J. 2017, 38, 770–779. [CrossRef]   
48. Awwad, A.S.; Ababneh, O.M.A.; Karasneh, M. The Mediating Impact of IT Capabilities on the Association between Dynamic Capabilities and Organizational Agility: The Case of the Jordanian IT Sector. Glob. J. Flex. Syst. Manag. 2022, 23, 315–330. [CrossRef]   
49. Watson, R.T.; Webster, J. Analysing the Past to Prepare for the Future: Writing a Literature Review a Roadmap for Release 2.0. J. Decis. Syst. 2020, 29, 129–147. [CrossRef]   
50. Çebeci, H.˙I. Artificial Intelligence Applications in Management Information Systems: A Comprehensive Systematic Review with Business Analytics Perspective. Artif. Intell. Theory Appl. 2021, 1, 25–56.   
51. Enholm, I.M.; Papagiannidis, E.; Mikalef, P.; Krogstie, J. Artificial Intelligence and Business Value: A Literature Review. Inf. Syst. Front. 2021, 24, 1709–1734. [CrossRef]   
52. Zuiderwijk, A.; Chen, Y.-C.; Salem, F. Implications of the Use of Artificial Intelligence in Public Governance: A Systematic Literature Review and a Research Agenda. Gov. Inf. Q. 2021, 38, 101577. [CrossRef]   
53. Grover, P.; Kar, A.K.; Dwivedi, Y.K. Understanding Artificial Intelligence Adoption in Operations Management: Insights from the Review of Academic Literature and Social Media Discussions. Ann. Oper. Res. 2022, 308, 177–213. [CrossRef]   
54. Caner, S.; Bhatti, F. A Conceptual Framework on Defining Businesses Strategy for Artificial Intelligence. Contemp. Manag. Res. 2020, 16, 175–206. [CrossRef]   
55. Smacchia, M.; Za, S. Artificial Intelligence in Organisation and Managerial Studies: A Computational Literature Review. In Proceedings of the ICIS 2022 Proceedings, Copenhagen, Denmark, 9–14 December 2022.   
56. Di Vaio, A.; Palladino, R.; Hassan, R.; Escobar, O. Artificial Intelligence and Business Models in the Sustainable Development Goals Perspective: A Systematic Literature Review. J. Bus. Res. 2020, 121, 283–314. [CrossRef]   
57. Dhamija, P.; Bag, S. Role of Artificial Intelligence in Operations Environment: A Review and Bibliometric Analysis. TQM 2020, 32, 869–896. [CrossRef]   
58. Haenlein, M.; Kaplan, A. A Brief History of Artificial Intelligence: On the Past, Present, and Future of Artificial Intelligence. Calif. Manag. Rev. 2019, 61, 5–14. [CrossRef]   
59. Çark, Ö. Digital Conflicts in Strategic Business Management. In Conflict Management in Digital Business; Özsungur, F., Ed.; Emerald Publishing Limited: Bingley, UK, 2022; pp. 205–222, ISBN 978-1-80262-774-9.   
60. Shrestha, Y.R.; Ben-Menahem, S.M.; von Krogh, G. Organizational Decision-Making Structures in the Age of Artificial Intelligence. Calif. Manag. Rev. 2019, 61, 66–83. [CrossRef]   
61. Shrestha, Y.R.; Krishna, V.; von Krogh, G. Augmenting Organizational Decision-Making with Deep Learning Algorithms: Principles, Promises, and Challenges. J. Bus. Res. 2021, 123, 588–603. [CrossRef]   
62. von Krogh, G. Artificial Intelligence in Organizations: New Opportunities for Phenomenon-Based Theorizing. Acad. Manag. Discov. 2018, 4, 404–409. [CrossRef]   
63. Agrawal, A.; Gans, J.; Goldfarb, A. Economic Policy for Artificial Intelligence. Innov. Policy Econ. 2019, 19, 139–159. [CrossRef]   
64. Jarzabkowski, P.; Balogun, J.; Seidl, D. Strategizing: The Challenges of a Practice Perspective. Hum. Relat. 2007, 60, 5–27. [CrossRef]   
65. Whittington, R. Information Systems Strategy and Strategy-as-Practice: A Joint Agenda. J. Strateg. Inf. Syst. 2014, 23, 87–91. [CrossRef]   
66. Von Krogh, G.; Ben-Menahem, S.M.; Shrestha, Y.R. Artificial Intelligence in Strategizing: Prospects and Challenges. In Strategic Management; Oxford University Press: Oxford, UK, 2021; pp. 625–646, ISBN 978-0-19-009088-3.   
67. Liu, J.; Chang, H.; Forrest, J.Y.-L.; Yang, B. Influence of Artificial Intelligence on Technological Innovation: Evidence from the Panel Data of China’s Manufacturing Sectors. Technol. Forecast. Soc. Chang. 2020, 158, 120142. [CrossRef]   
68. Benner, M.J.; Tushman, M.L. Exploration, exploitation and process management: The productivity dilemma revisited. Acad. Manag. J. 2003, 28, 238–256. [CrossRef]   
69. Carter, M.; Petter, S.; Grover, V.; Thatcher, J.B. Information Technology Identity: A Key Determinant of IT Feature and Exploratory Usage. MIS Q. 2020, 44, 983–1021. [CrossRef]   
70. Lee, O.-K.; Sambamurthy, V.; Lim, K.H.; Wei, K.K. How Does IT Ambidexterity Impact Organizational Agility? Inf. Syst. Res. 2015, 26, 398–417. [CrossRef]   
71. Sestino, A.; De Mauro, A. Leveraging Artificial Intelligence in Business: Implications, Applications and Methods. Technol. Anal. Strateg. Manag. 2022, 34, 16–29. [CrossRef]   
72. Warner, K.S.R.; Wäger, M. Building Dynamic Capabilities for Digital Transformation: An Ongoing Process of Strategic Renewal. Long Range Plan. 2019, 52, 326–349. [CrossRef]   
73. Huang, M.-H.; Rust, R.T. A Strategic Framework for Artificial Intelligence in Marketing. J. Acad. Mark. Sci. 2021, 49, 30–50. [CrossRef]   
74. Wamba-Taguimdje, S.-L.; Wamba, S.F.; Kamdjoug, J.R.K.; Wanko, C.E.T. Impact of Artificial Intelligence on Firm Performance: Exploring the Mediating Effect of Process-Oriented Dynamic Capabilities. In Digital Business Transformation; Agrifoglio, R., Lamboglia, R., Mancini, D., Ricciardi, F., Eds.; Lecture Notes in Information Systems and Organisation; Springer International Publishing: Cham, Switzerland, 2020; Volume 38, pp. 3–18, ISBN 978-3-030-47354-9.   
75. Papachroni, A.; Heracleous, L.; Paroutis, S. Organizational Ambidexterity Through the Lens of Paradox Theory: Building a Novel Research Agenda. J. Appl. Behav. Sci. 2015, 51, 71–93. [CrossRef]   
76. van de Wetering, R.; Versendaal, J. Information Technology Ambidexterity, Digital Dynamic Capability, and Knowledge Processes as Enablers of Patient Agility: Empirical Study. JMIRx Med. 2021, 2, e32336. [CrossRef]   
77. Diaz-Fernandez, M.; Pasamar-Reyes, S.; Valle-Cabrera, R. Human Capital and Human Resource Management to Achieve Ambidextrous Learning: A Structural Perspective. BRQ Bus. Res. Q. 2017, 20, 63–77. [CrossRef]   
78. Jansen, J.J.P.; Van Den Bosch, F.A.J.; Volberda, H.W. Exploratory Innovation, Exploitative Innovation, and Performance: Effects of Organizational Antecedents and Environmental Moderators. Manag. Sci. 2006, 52, 1661–1674. [CrossRef]   
79. Paschen, J.; Wilson, M.; Ferreira, J.J. Collaborative Intelligence: How Human and Artificial Intelligence Create Value along the B2B Sales Funnel. Bus. Horiz. 2020, 63, 403–414. [CrossRef]   
80. Phan, P.; Wright, M.; Lee, S.-H. Of Robots, Artificial Intelligence, and Work. Acad. Manag. Perspect. 2017, 31, 253–255. [CrossRef]   
81. Garbuio, M.; Lin, N. Artificial Intelligence as a Growth Engine for Health Care Startups: Emerging Business Models. Calif. Manag. Rev. 2019, 61, 59–83. [CrossRef]   
82. Hengstler, M.; Enkel, E.; Duelli, S. Applied Artificial Intelligence and Trust—The Case of Autonomous Vehicles and Medical Assistance Devices. Technol. Forecast. Soc. Chang. 2016, 105, 105–120. [CrossRef]   
83. Barro, S.; Davenport, T.H. People and Machines: Partners in Innovation. MIT Sloan Manag. Rev. 2019, 60, 22–28.   
84. Desouza, K.C.; Dawson, G.S.; Chenok, D. Designing, Developing, and Deploying Artificial Intelligence Systems: Lessons from and for the Public Sector. Bus. Horiz. 2020, 63, 205–213. [CrossRef]   
85. Reis, C.; Ruivo, P.; Oliveira, T.; Faroleiro, P. Assessing the Drivers of Machine Learning Business Value. J. Bus. Res. 2020, 117, 232–243. [CrossRef]   
86. Alsheibani, S.A.; Cheung, Y.; Messom, D.C.; Alhosni, M. Winning AI Strategy: Six-Steps to Create Value from Artificial Intelligence. AMCIS Proc. 2020, 11. Available online: https://aisel.aisnet.org/amcis2020/adv_info_systems_research/adv_info_systems_ research/1/ (accessed on 1 January 2023).   
87. Sjödin, D.; Parida, V.; Palmié, M.; Wincent, J. How AI Capabilities Enable Business Model Innovation: Scaling AI through Co-Evolutionary Processes and Feedback Loops. J. Bus. Res. 2021, 134, 574–587. [CrossRef]   
88. Weber, M.; Engert, M.; Schaffer, N.; Weking, J.; Krcmar, H. Organizational Capabilities for AI Implementation—Coping with Inscrutability and Data Dependency in AI. Inf. Syst. Front. 2022, 1–21. [CrossRef]   
89. Melville, N.; Gurbaxani, V.; Kraemer, K. The Productivity Impact of Information Technology across Competitive Regimes: The Role of Industry Concentration and Dynamism. Decis. Support Syst. 2007, 43, 229–242. [CrossRef]   
90. Aydiner, A.S.; Tatoglu, E.; Bayraktar, E.; Zaim, S.; Delen, D. Business Analytics and Firm Performance: The Mediating Role of Business Process Performance. J. Bus. Res. 2019, 96, 228–237. [CrossRef]   
91. Wade, M.; Hulland, J. Review: The resource-based view and information systems research: Review, extension, and suggestions for future research. MIS Q. 2004, 28, 107–142. [CrossRef]   
92. Barney, J.B. Purchasing, Supply Chain Management and Sustained Competitive Advantage: The Relevance of Resource-Based Theory. J. Supply Chain Manag. 2012, 48, 3–6. [CrossRef]   
93. Barney, J.B. Resource-Based Theories of Competitive Advantage: A Ten-Year Retrospective on the Resource-Based View. J. Manag. 2001, 27, 643–650. [CrossRef]   
94. Bromiley, P.; Rau, D. Operations Management and the Resource Based View: Another View. J. Oper. Manag. 2016, 41, 95–106. [CrossRef]   
95. Bamel, U.K.; Bamel, N. Organizational Resources, KM Process Capability and Strategic Flexibility: A Dynamic Resource-Capability Perspective. J. Knowl. Manag. 2018, 22, 1555–1572. [CrossRef]   
96. Gupta, M.; George, J.F. Toward the development of a big data analytics capability. Inf. Manag. 2016, 53, 1049–1064. [CrossRef]   
97. Ravichandran, T.; Lertwongsatien, C.; Lertwongsatien, C. Effect of Information Systems Resources and Capabilities on Firm Performance: A Resource-Based Perspective. J. Manag. Inf. Syst. 2005, 21, 237–276. [CrossRef]   
98. Mikalef, P.; Fjørtoft, S.O.; Torvatn, H.Y. Developing an Artificial Intelligence Capability: A Theoretical Framework for Business Value. In Business Information Systems Workshops; Abramowicz, W., Corchuelo, R., Eds.; Lecture Notes in Business Information Processing; Springer International Publishing: Cham, Switzerland, 2019; Volume 373, pp. 409–416, ISBN 978-3-030-36690-2.   
99. Morgan, N.A.; Vorhies, D.W.; Schlegelmilch, B.B. Resource–Performance Relationships in Industrial Export Ventures: The Role of Resource Inimitability and Substitutability. Ind. Mark. Manag. 2006, 35, 621–633. [CrossRef]   
100. Seddon, P.B. Implications for Strategic IS Research of the Resource-Based Theory of the Firm: A Reflection. J. Strateg. Inf. Syst. 2014, 23, 257–269. [CrossRef]   
101. Uren, V.; Edwards, J.S. Technology Readiness and the Organizational Journey towards AI Adoption: An Empirical Study. Int. J. Inf. Manag. 2023, 68, 102588. [CrossRef]   
102. Kurniawan, R.; Manurung, A.H.; Hamsal, M.; Kosasih, W. Orchestrating Internal and External Resources to Achieve Agility and Performance: The Centrality of Market Orientation. BIJ 2020, 28, 517–555. [CrossRef]   
103. Carnes, C.M.; Chirico, F.; Hitt, M.A.; Huh, D.W.; Pisano, V. Resource Orchestration for Innovation: Structuring and Bundling Resources in Growth- and Maturity-Stage Firms. Long Range Plan. 2017, 50, 472–486. [CrossRef]   
104. Mikalef, P.; Boura, M.; Lekakos, G.; Krogstie, J. Big Data Analytics Capabilities and Innovation: The Mediating Role of Dynamic Capabilities and Moderating Effect of the Environment. Br. J. Manag. 2019, 30, 272–298. [CrossRef]   
105. Garbuio, M.; King, A.W.; Lovallo, D. Looking Inside: Psychological Influences on Structuring a Firm’s Portfolio of Resources. J. Manag. 2011, 37, 1444–1463. [CrossRef]   
106. Ho, L.T.; Gan, C.; Jin, S.; Le, B. Artificial Intelligence and Firm Performance: Does Machine Intelligence Shield Firms from Risks? J. Risk Financ. Manag. 2022, 15, 302. [CrossRef]   
107. Sirmon, D.G.; Hitt, M.A.; Ireland, R.D. Managing Firm Resources in Dynamic Environments to Create Value: Looking Inside the Black Box. Acad. Manag. Rev. 2007, 32, 273–292. [CrossRef]   
108. Fosso Wamba, S. Impact of Artificial Intelligence Assimilation on Firm Performance: The Mediating Effects of Organizational Agility and Customer Agility. Int. J. Inf. Manag. 2022, 67, 102544. [CrossRef]   
109. Lee, M.C.M.; Scheepers, H.; Lui, A.K.H.; Ngai, E.W.T. The Role of Artificial Intelligence for Business Value. In Proceedings of the ICIS 2022, Copenhagen, Denmark, 9–14 December 2022. Available online: https://aisel.aisnet.org/icis2022/ai_business/ai_ business/3/ (accessed on 1 January 2023).   
110. Sirmon, D.G.; Hitt, M.A.; Ireland, R.D.; Gilbert, B.A. Resource Orchestration to Create Competitive Advantage: Breadth, Depth, and Life Cycle Effects. J. Manag. 2011, 37, 1390–1412. [CrossRef]   
111. van de Wetering, R.; Bosua, R.; Boersma, C.; Dohmen, D. Information Technology Ambidexterity-Driven Patient Agility, Patient Service- and Market Performance: A Variance and FsQCA Approach. Sustainability 2022, 14, 4371. [CrossRef]   
112. Papagiannidis, E.; Enholm, I.M.; Dremel, C.; Mikalef, P.; Krogstie, J. Deploying AI Governance Practices: A Revelatory Case Study. In Responsible AI and Analytics for an Ethical and Inclusive Digitized Society; Dennehy, D., Griva, A., Pouloudi, N., Dwivedi, Y.K., Pappas, I., Mäntymäki, M., Eds.; Lecture Notes in Computer Science; Springer International Publishing: Cham, Switzerland, 2021; Volume 12896, pp. 208–219, ISBN 978-3-030-85446-1.   
113. Fountaine, T.; McCarthy, B.; Saleh, T. Building the AI-Powered Organization. Harv. Bus. Rev. 2019, 97, 62–73.   
114. Lichtenthaler, U. An Intelligence-Based View of Firm Performance: Profiting from Artificial Intelligence. J. Innov. Manag. 2019, 7, 7–20. [CrossRef]   
115. Papagiannidis, E.; Mikalef, P.; Krogstie, J.; Conboy, K. From Responsible AI Governance to Competitive Performance: The Mediating Role of Knowledge Management Capabilities. In The Role of Digital Technologies in Shaping the Post-Pandemic World; Papagiannidis, S., Alamanos, E., Gupta, S., Dwivedi, Y.K., Mäntymäki, M., Pappas, I.O., Eds.; Lecture Notes in Computer Science; Springer International Publishing: Cham, Switzerland, 2022; Volume 13454, pp. 58–69, ISBN 978-3-031-15341-9.   
116. de Laat, P.B. Companies Committed to Responsible AI: From Principles towards Implementation and Regulation? Philos. Technol. 2021, 34, 1135–1193. [CrossRef] [PubMed]   
117. Borgman, H.; Heier, H.; Bahli, B.; Boekamp, T. Dotting the I and Crossing (out) the T in IT Governance: New Challenges for Information Governance. In Proceedings of the 2016 49th Hawaii International Conference on System Sciences (HICSS), Koloa, HI, USA, 5–8 January 2016; pp. 4901–4909.   
118. Kruhse-Lehtonen, U.; Hofmann, D. How to Define and Execute Your Data and AI Strategy. Harv. Data Sci. Rev. 2020. Available online: https://hdsr.mitpress.mit.edu/pub/4vlrf0x2/release/1 (accessed on 1 January 2023).   
119. Schneider, J.; Abraham, R.; Meske, C.; Vom Brocke, J. Artificial Intelligence Governance For Businesses. Inf. Syst. Manag. 2022, 1–21. [CrossRef]   
120. Chen, D.; Esperança, J.P.; Wang, S. The Impact of Artificial Intelligence on Firm Performance: An Application of the ResourceBased View to e-Commerce Firms. Front. Psychol. 2022, 13, 884830. [CrossRef] [PubMed]   
121. Smit, K.; Zoet, M.; van Meerten, J. A Review of AI Principles in Practice. In Proceedings of the PACIS 2020 Proceedings, Dubai, United Arab Emirates, 20–24 June 2020.   
122. Alsheiabni, S.; Cheung, Y.; Messom, C. Towards An Artificial Intelligence Maturity Model: From Science Fiction to Business Facts. In Proceedings of the PACIS, Xi’an, China, 8–12 July 2019; p. 9. Available online: https://aisel.aisnet.org/pacis2019/46/ (accessed on 1 January 2023).   
123. Abraham, R.; Schneider, J.; vom Brocke, J. Data Governance: A Conceptual Framework, Structured Review, and Research Agenda. Int. J. Inf. Manag. 2019, 49, 424–438. [CrossRef]   
124. Ashmore, R.; Calinescu, R.; Paterson, C. Assuring the Machine Learning Lifecycle: Desiderata, Methods, and Challenges. ACM Comput. Surv. 2022, 54, 1–39. [CrossRef]   
125. Scherer, M.U. Regulating Artificial Intelligence Systems: Risks, Challenges, Competencies, and Strategies. SSRN J. 2015, 29, 48. [CrossRef]   
126. Clarke, R. Principles and Business Processes for Responsible AI. Comput. Law Secur. Rev. 2019, 35, 410–422. [CrossRef]   
127. Brundage, M.; Avin, S.; Wang, J.; Belfield, H.; Krueger, G.; Hadfield, G.; Khlaaf, H.; Yang, J.; Toner, H.; Fong, R.; et al. Toward Trustworthy AI Development: Mechanisms for Supporting Verifiable Claims. 2020. Available online: http://arxiv.org/abs/2004.07213 (accessed on 1 December 2021).   
128. Phillips-Wren, G.; Jain, L. Artificial Intelligence for Decision Making. In Knowledge-Based Intelligent Information and Engineering Systems; Gabrys, B., Howlett, R.J., Jain, L.C., Eds.; Lecture Notes in Computer Science; Springer: Berlin/Heidelberg, Germany, 2006; Volume 4252, pp. 531–536. ISBN 978-3-540-46537-9.   
129. Kaplan, A.; Haenlein, M. Siri, Siri, in My Hand: Who’s the Fairest in the Land? On the Interpretations, Illustrations, and Implications of Artificial Intelligence. Bus. Horiz. 2019, 62, 15–25. [CrossRef]   
130. Chi, M.; Zhao, J.; George, J.F.; Li, Y.; Zhai, S. The Influence of Inter-Firm IT Governance Strategies on Relational Performance: The Moderation Effect of Information Technology Ambidexterity. Int. J. Inf. Manag. 2017, 37, 43–53. [CrossRef]   
131. Minkkinen, M.; Zimmer, M.P.; Mäntymäki, M. Towards Ecosystems for Responsible AI: Expectations on Sociotechnical Systems, Agendas, and Networks in EU Documents. In Responsible AI and Analytics for an Ethical and Inclusive Digitized Society; Dennehy, D., Griva, A., Pouloudi, N., Dwivedi, Y.K., Pappas, I., Mäntymäki, M., Eds.; Lecture Notes in Computer Science; Springer International Publishing: Cham, Switzerland, 2021; Volume 12896, pp. 220–232, ISBN 978-3-030-85446-1.   
132. Ledro, C.; Nosella, A.; Vinelli, A. Artificial Intelligence in Customer Relationship Management: Literature Review and Future Research Directions. JBIM 2022, 37, 48–63. [CrossRef]   
133. Lwakatare, L.E.; Raj, A.; Bosch, J.; Olsson, H.H.; Crnkovic, I. A Taxonomy of Software Engineering Challenges for Machine Learning Systems: An Empirical Investigation. In Agile Processes in Software Engineering and Extreme Programming; Kruchten, P., Fraser, S., Coallier, F., Eds.; Lecture Notes in Business Information Processing; Springer International Publishing: Cham, Switzerland, 2019; Volume 355, pp. 227–243, ISBN 978-3-030-19033-0.   
134. Wang, X.; Lin, X.; Shao, B. How Does Artificial Intelligence Create Business Agility? Evidence from Chatbots. Int. J. Inf. Manag. 2022, 66, 102535. [CrossRef]   
135. Dignum, V. Responsible Artificial Intelligence: How to Develop and Use AI in a Responsible Way; Artificial Intelligence: Foundations, Theory, and Algorithms; Springer International Publishing: Cham, Switzerland, 2019; ISBN 978-3-030-30370-9.   
136. Brozovic, D. Strategic Flexibility: A Review of the Literature: Strategic Flexibility. Int. J. Manag. Rev. 2018, 20, 3–31. [CrossRef]   
137. Escrig-Tena, A.B.; Bou-Llusar, J.C.; Beltrán-Martín, I.; Roca-Puig, V. Modelling the Implications of Quality Management Elements on Strategic Flexibility. Adv. Decis. Sci. 2011, 2011, 1–27. [CrossRef]   
138. van de Wetering, R.; Mikalef, P.; Pateli, A. Managing Firms’ Innovation Capabilities through Strategically Aligning Combinative IT and Dynamic Capabilities. 11. Available online: https://www.researchgate.net/publication/316596939_Managing_firms%27 _innovation_capabilities_through_strategically_aligning_combinative_IT_and_dynamic_capabilities (accessed on 1 January 2023).   
139. Mikalef, P.; Pateli, A. Information Technology-Enabled Dynamic Capabilities and Their Indirect Effect on Competitive Performance: Findings from PLS-SEM and FsQCA. J. Bus. Res. 2017, 70, 1–16. [CrossRef]   
140. Eisenhardt, K.M.; Furr, N.R.; Bingham, C.B. Crossroads—Microfoundations of Performance: Balancing Efficiency and Flexibility in Dynamic Environments. Organ. Sci. 2010, 21, 1263–1273. [CrossRef]   
141. Nadkarni, S.; Narayanan, V.K. Strategic Schemas, Strategic Flexibility, and Firm Performance: The Moderating Role of Industry Clockspeed. Strateg. Manag. J. 2007, 28, 243–270. [CrossRef]   
142. Haarhaus, T.; Liening, A. Building Dynamic Capabilities to Cope with Environmental Uncertainty: The Role of Strategic Foresight. Technol. Forecast. Soc. Chang. 2020, 155, 120033. [CrossRef]   
143. Shimizu, K.; Hitt, M.A. Strategic Flexibility:Organizational Preparedness to Reverse Ineffective Strategic Decisions. Acad. Manag. Perspect. 2004, 18, 44–59. [CrossRef]   
144. Combe, I.A.; Rudd, J.M.; Leeflang, P.S.H.; Greenley, G.E. Antecedents to Strategic Flexibility: Management Cognition, Firm Resources and Strategic Options. Eur. J. Mark. 2012, 46, 1320–1339. [CrossRef]   
145. Radomska, J. Strategic Flexibility of Enterprises. J. Econ. Bus. Manag. 2015, 3, 19–23. [CrossRef]   
146. Bock, A.J.; Opsahl, T.; George, G.; Gann, D.M. The Effects of Culture and Structure on Strategic Flexibility during Business Model Innovation: Flexibility during Business Model Innovation. J. Manag. Stud. 2012, 49, 279–305. [CrossRef]   
147. Kortmann, S.; Gelhard, C.; Zimmermann, C.; Piller, F.T. Linking Strategic Flexibility and Operational Efficiency: The Mediating Role of Ambidextrous Operational Capabilities. J. Oper. Manag. 2014, 32, 475–490. [CrossRef]   
148. van de Wetering, R.; Mikalef, P. The Effect of Strategic Alignment of Complementary IT and Organizational Capabilities on Competitive Firm Performance. In Business Information Systems Workshops; Abramowicz, W., Ed.; Lecture Notes in Business Information Processing; Springer International Publishing: Cham, Switzerland, 2017; Volume 303, pp. 115–126, ISBN 978-3-319-69022-3.   
149. Matalamäki, M.J.; Joensuu-Salo, S. Digitalization and Strategic Flexibility–a Recipe for Business Growth. J. Small Bus. Enterp. Dev. 2022, 29, 380–401. [CrossRef]   
150. Yi, Y.; Gu, M.; Wei, Z. Bottom-up Learning, Strategic Flexibility and Strategic Change. J. Organ. Change Manag. 2017, 30, 161–183. [CrossRef]   
151. Chan, J.T.; Zhong, W. Reading China: Predicting Policy Change with Machine Learning. SSRN J. 2018, 43. [CrossRef]   
152. Avramov, D.; Cheng, S.; Metzker, L. Machine Learning vs. Economic Restrictions: Evidence from Stock Return Predictability. Manag. Sci. 2022. [CrossRef]   
153. Kou, G.; Chao, X.; Peng, Y.; Alsaadi, F.E.; Herrera-Viedma, E. Machine Learning Methods for Systemic Risk Analysis in Financial Sectors. Technol. Econ. Dev. Econ. 2019, 25, 716–742. [CrossRef]   
154. Bail, C.A. The Cultural Environment: Measuring Culture with Big Data. Theor. Soc. 2014, 43, 465–482. [CrossRef]   
155. Lee, C.; Kwon, O.; Kim, M.; Kwon, D. Early Identification of Emerging Technologies: A Machine Learning Approach Using Multiple Patent Indicators. Technol. Forecast. Soc. Chang. 2018, 127, 291–303. [CrossRef]   
156. Suominen, A.; Toivanen, H.; Seppänen, M. Firms’ Knowledge Profiles: Mapping Patent Data with Unsupervised Learning. Technol. Forecast. Soc. Chang. 2017, 115, 131–142. [CrossRef]   
157. Khan, H.U.; Malik, M.Z.; Alomari, M.K.B.; Khan, S.; Al-Maadid, A.A.S.A.; Hassan, M.K.; Khan, K. Transforming the Capabilities of Artificial Intelligence in GCC Financial Sector: A Systematic Literature Review. Wirel. Commun. Mob. Comput. 2022, 2022, 8725767. [CrossRef]   
158. Fethi, M.D.; Pasiouras, F. Assessing Bank Efficiency and Performance with Operational Research and Artificial Intelligence Techniques: A Survey. Eur. J. Oper. Res. 2010, 204, 189–198. [CrossRef]   
159. Mishra, S.; Ewing, M.T.; Cooper, H.B. Artificial Intelligence Focus and Firm Performance. J. Acad. Mark. Sci. 2022, 50, 1176–1197. [CrossRef]   
160. Cheung, C.F.; Wang, W.M.; Lo, V.; Lee, W.B. An Agent-Oriented and Knowledge-Based System for Strategic e-Procurement. Expert Syst. 2004, 21, 11–21. [CrossRef]   
161. Hollebeek, L.D.; Conduit, J.; Brodie, R.J. Strategic Drivers, Anticipated and Unanticipated Outcomes of Customer Engagement. J. Mark. Manag. 2016, 32, 393–398. [CrossRef]   
162. Gomez-Uribe, C.A.; Hunt, N. The Netflix Recommender System: Algorithms, Business Value, and Innovation. ACM Trans. Manag. Inf. Syst. 2016, 6, 1–19. [CrossRef]   
163. Drydakis, N. Artificial Intelligence and Reduced SMEs’ Business Risks. A Dynamic Capabilities Analysis During the COVID-19 Pandemic. Inf. Syst. Front. 2022, 24, 1223–1247. [CrossRef]   
164. Brynjolfsson, E.; Mitchell, T. What Can Machine Learning Do? Workforce Implications. Science 2017, 358, 1530–1534. [CrossRef]   
165. Moloi, T.; Marwala, T. Artificial Intelligence and the Changing Nature of Corporations: How Technologies Shape Strategy and Operations; Future of Business and Finance; Springer International Publishing: Cham, Switzerland, 2021; ISBN 978-3-030-76312-1.   
166. Benitez, J.; Castillo, A.; Llorens, J.; Braojos, J. IT-Enabled Knowledge Ambidexterity and Innovation Performance in Small U.S. Firms: The Moderator Role of Social Media Capability. Inf. Manag. 2018, 55, 131–143. [CrossRef]   
167. Robert Baum, J.; Wally, S. Strategic Decision Speed and Firm Performance. Strateg. Manag. J. 2003, 24, 1107–1129. [CrossRef]   
168. Coombs, C.; Hislop, D.; Taneva, S.K.; Barnard, S. The Strategic Impacts of Intelligent Automation for Knowledge and Service Work: An Interdisciplinary Review. J. Strateg. Inf. Syst. 2020, 29, 101600. [CrossRef]   
169. Menon, A.; Choi, J.; Tabakovic, H. What You Say Your Strategy Is and Why It Matters: Natural Language Processing of Unstructured Text. Proceedings 2018, 2018, 18319. [CrossRef]   
170. Trocin, C.; Hovland, I.V.; Mikalef, P.; Dremel, C. How Artificial Intelligence Affords Digital Innovation: A Cross-Case Analysis of Scandinavian Companies. Technol. Forecast. Soc. Chang. 2021, 173, 121081. [CrossRef]   
171. Chalmers, D.; MacKenzie, N.G.; Carter, S. Artificial Intelligence and Entrepreneurship: Implications for Venture Creation in the Fourth Industrial Revolution. Entrep. Theory Pract. 2021, 45, 1028–1053. [CrossRef]   
172. Roberts, N.; Grover, V. Leveraging Information Technology Infrastructure to Facilitate a Firm’s Customer Agility and Competitive Activity: An Empirical Investigation. J. Manag. Inf. Syst. 2012, 28, 231–270. [CrossRef]   
173. Sambamurthy; Bharadwaj; Grover Shaping Agility through Digital Options: Reconceptualizing the Role of Information Technology in Contemporary Firms. MIS Q. 2003, 27, 237. [CrossRef]   
174. Lui, A.K.H.; Lee, M.C.M.; Ngai, E.W.T. Impact of Artificial Intelligence Investment on Firm Value. Ann. Oper. Res. 2022, 308, 373–388. [CrossRef]   
175. Braganza, A.; Brooks, L.; Nepelski, D.; Ali, M.; Moro, R. Resource Management in Big Data Initiatives: Processes and Dynamic Capabilities. J. Bus. Res. 2017, 70, 328–337. [CrossRef]   
176. Rialti, R.; Marzi, G.; Caputo, A.; Mayah, K.A. Achieving Strategic Flexibility in the Era of Big Data: The Importance of Knowledge Management and Ambidexterity. Manag. Decis. 2020, 58, 1585–1600. [CrossRef]   
177. Verganti, R.; Vendraminelli, L.; Iansiti, M. Innovation and Design in the Age of Artificial Intelligence. J. Prod. Innov. Manag. 2020, 37, 212–227. [CrossRef]   
178. Chen, Y. Dynamic Ambidexterity: How Innovators Manage Exploration and Exploitation. Bus. Horiz. 2017, 60, 385–394. [CrossRef]   
179. Miroshnychenko, I.; Strobl, A.; Matzler, K.; De Massis, A. Absorptive Capacity, Strategic Flexibility, and Business Model Innovation: Empirical Evidence from Italian SMEs. J. Bus. Res. 2021, 130, 670–682. [CrossRef]   
180. Li, C.; Khan, A.; Ahmad, H.; Shahzad, M. Business Analytics Competencies in Stabilizing Firms’ Agility and Digital Innovation amid COVID-19. J. Innov. Knowl. 2022, 7, 100246. [CrossRef]   
181. Grewal, R.; Tansuhaj, P. Building Organizational Capabilities for Managing Economic Crisis: The Role of Market Orientation and Strategic Flexibility. J. Mark. 2001, 65, 67–80. [CrossRef]   
182. Helfat, C.E.; Peteraf, M.A. Understanding Dynamic Capabilities: Progress along a Developmental Path. Strateg. Organ. 2009, 7, 91–102. [CrossRef]